/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.messaging;

import java.util.AbstractList;
import java.util.List;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.codec.AbstractDescribedType;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DescribedTypeConstructor;
import org.apache.qpid.proton.codec.EncoderImpl;

public class HeaderType
extends AbstractDescribedType<Header, List>
implements DescribedTypeConstructor<Header> {
    private static final Object[] DESCRIPTORS = new Object[]{UnsignedLong.valueOf(112L), Symbol.valueOf("amqp:header:list")};
    private static final UnsignedLong DESCRIPTOR = UnsignedLong.valueOf(112L);

    public HeaderType(EncoderImpl encoder) {
        super(encoder);
    }

    @Override
    protected UnsignedLong getDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    protected List wrap(Header val) {
        return new HeaderWrapper(val);
    }

    @Override
    public Header newInstance(Object described) {
        List l = (List)described;
        Header o = new Header();
        switch (5 - l.size()) {
            case 0: {
                o.setDeliveryCount((UnsignedInteger)l.get(4));
            }
            case 1: {
                o.setFirstAcquirer((Boolean)l.get(3));
            }
            case 2: {
                o.setTtl((UnsignedInteger)l.get(2));
            }
            case 3: {
                o.setPriority((UnsignedByte)l.get(1));
            }
            case 4: {
                o.setDurable((Boolean)l.get(0));
            }
        }
        return o;
    }

    @Override
    public Class<Header> getTypeClass() {
        return Header.class;
    }

    public static void register(Decoder decoder, EncoderImpl encoder) {
        HeaderType type = new HeaderType(encoder);
        for (Object descriptor : DESCRIPTORS) {
            decoder.register(descriptor, type);
        }
        encoder.register(type);
    }

    public static final class HeaderWrapper
    extends AbstractList {
        private final Header _impl;

        public HeaderWrapper(Header impl) {
            this._impl = impl;
        }

        @Override
        public Object get(int index) {
            switch (index) {
                case 0: {
                    return this._impl.getDurable();
                }
                case 1: {
                    return this._impl.getPriority();
                }
                case 2: {
                    return this._impl.getTtl();
                }
                case 3: {
                    return this._impl.getFirstAcquirer();
                }
                case 4: {
                    return this._impl.getDeliveryCount();
                }
            }
            throw new IllegalStateException("Unknown index " + index);
        }

        @Override
        public int size() {
            return this._impl.getDeliveryCount() != null ? 5 : (this._impl.getFirstAcquirer() != null ? 4 : (this._impl.getTtl() != null ? 3 : (this._impl.getPriority() != null ? 2 : (this._impl.getDurable() != null ? 1 : 0))));
        }
    }
}

