/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public abstract class MessageSourceSupport {
    private static final MessageFormat INVALID_MESSAGE_FORMAT = new MessageFormat("");
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean alwaysUseMessageFormat = false;
    private final Map<String, Map<Locale, MessageFormat>> messageFormatsPerMessage = new ConcurrentHashMap<String, Map<Locale, MessageFormat>>();

    public void setAlwaysUseMessageFormat(boolean alwaysUseMessageFormat) {
        this.alwaysUseMessageFormat = alwaysUseMessageFormat;
    }

    protected boolean isAlwaysUseMessageFormat() {
        return this.alwaysUseMessageFormat;
    }

    protected String renderDefaultMessage(String defaultMessage, @Nullable Object[] args, Locale locale) {
        return this.formatMessage(defaultMessage, args, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String formatMessage(String msg, @Nullable Object[] args, Locale locale) {
        if (!this.isAlwaysUseMessageFormat() && ObjectUtils.isEmpty(args)) {
            return msg;
        }
        Map messageFormatsPerLocale = this.messageFormatsPerMessage.computeIfAbsent(msg, key -> new ConcurrentHashMap());
        MessageFormat messageFormat = messageFormatsPerLocale.computeIfAbsent(locale, key -> {
            try {
                return this.createMessageFormat(msg, locale);
            }
            catch (IllegalArgumentException ex) {
                if (this.isAlwaysUseMessageFormat()) {
                    throw ex;
                }
                return INVALID_MESSAGE_FORMAT;
            }
        });
        if (messageFormat == INVALID_MESSAGE_FORMAT) {
            return msg;
        }
        MessageFormat messageFormat2 = messageFormat;
        synchronized (messageFormat2) {
            return messageFormat.format(this.resolveArguments(args, locale));
        }
    }

    protected MessageFormat createMessageFormat(String msg, Locale locale) {
        return new MessageFormat(msg, locale);
    }

    protected Object[] resolveArguments(@Nullable Object[] args, Locale locale) {
        return args != null ? args : new Object[]{};
    }
}

