/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc.adapter;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.activemq.store.jdbc.Statements;
import org.apache.activemq.store.jdbc.adapter.DefaultJDBCAdapter;

public class MySqlJDBCAdapter
extends DefaultJDBCAdapter {
    public static final String INNODB = "INNODB";
    public static final String NDBCLUSTER = "NDBCLUSTER";
    public static final String BDB = "BDB";
    public static final String MYISAM = "MYISAM";
    public static final String ISAM = "ISAM";
    public static final String MERGE = "MERGE";
    public static final String HEAP = "HEAP";
    String engineType = "INNODB";
    String typeStatement = "ENGINE";

    @Override
    public void setStatements(Statements statements) {
        String type = this.engineType.toUpperCase();
        if (!type.equals(INNODB) && !type.equals(NDBCLUSTER)) {
            statements.setLockCreateStatement("LOCK TABLE " + statements.getFullLockTableName() + " WRITE");
        }
        statements.setBinaryDataType("LONGBLOB");
        String typeClause = this.typeStatement + "=" + type;
        if (type.equals(NDBCLUSTER)) {
            typeClause = this.typeStatement + "=INNODB";
        }
        String[] s = statements.getCreateSchemaStatements();
        for (int i2 = 0; i2 < s.length; ++i2) {
            if (!s[i2].startsWith("CREATE TABLE")) continue;
            s[i2] = s[i2] + " " + typeClause;
        }
        if (type.equals(NDBCLUSTER)) {
            ArrayList<String> l = new ArrayList<String>(Arrays.asList(s));
            l.add("ALTER TABLE " + statements.getFullMessageTableName() + " ENGINE=NDBCLUSTER");
            l.add("ALTER TABLE " + statements.getFullAckTableName() + " ENGINE=NDBCLUSTER");
            l.add("ALTER TABLE " + statements.getFullLockTableName() + " ENGINE=NDBCLUSTER");
            l.add("FLUSH TABLES");
            s = l.toArray(new String[l.size()]);
            statements.setCreateSchemaStatements(s);
        }
        super.setStatements(statements);
    }

    public String getEngineType() {
        return this.engineType;
    }

    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }

    public String getTypeStatement() {
        return this.typeStatement;
    }

    public void setTypeStatement(String typeStatement) {
        this.typeStatement = typeStatement;
    }

    @Override
    public String limitQuery(String query) {
        return query + " LIMIT " + this.getMaxRows();
    }
}

