// @generated by protobuf-ts 2.1.0 with parameter client_grpc1,generate_dependencies
// @generated from protobuf file "org/apache/beam/model/job_management/v1/beam_job_api.proto" (package "org.apache.beam.model.job_management.v1", syntax proto3)
// tslint:disable
//
//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//
//
// Protocol Buffers describing the Job API, api for communicating with a runner
// for job submission over GRPC.
//
import { JobService } from "./beam_job_api";
import type { BinaryWriteOptions } from "@protobuf-ts/runtime";
import type { BinaryReadOptions } from "@protobuf-ts/runtime";
import type { DescribePipelineOptionsResponse } from "./beam_job_api";
import type { DescribePipelineOptionsRequest } from "./beam_job_api";
import type { GetJobMetricsResponse } from "./beam_job_api";
import type { GetJobMetricsRequest } from "./beam_job_api";
import type { JobMessagesResponse } from "./beam_job_api";
import type { JobMessagesRequest } from "./beam_job_api";
import type { CancelJobResponse } from "./beam_job_api";
import type { CancelJobRequest } from "./beam_job_api";
import type { GetJobPipelineResponse } from "./beam_job_api";
import type { GetJobPipelineRequest } from "./beam_job_api";
import type { JobStateEvent } from "./beam_job_api";
import type { GetJobStateRequest } from "./beam_job_api";
import type { GetJobsResponse } from "./beam_job_api";
import type { GetJobsRequest } from "./beam_job_api";
import type { RunJobResponse } from "./beam_job_api";
import type { RunJobRequest } from "./beam_job_api";
import type { PrepareJobResponse } from "./beam_job_api";
import type { PrepareJobRequest } from "./beam_job_api";
import * as grpc from "@grpc/grpc-js";
/**
 * Job Service for running RunnerAPI pipelines
 *
 * @generated from protobuf service org.apache.beam.model.job_management.v1.JobService
 */
export interface IJobServiceClient {
    /**
     * Prepare a job for execution. The job will not be executed until a call is made to run with the
     * returned preparationId.
     *
     * @generated from protobuf rpc: Prepare(org.apache.beam.model.job_management.v1.PrepareJobRequest) returns (org.apache.beam.model.job_management.v1.PrepareJobResponse);
     */
    prepare(input: PrepareJobRequest, metadata: grpc.Metadata, options: grpc.CallOptions, callback: (err: grpc.ServiceError | null, value?: PrepareJobResponse) => void): grpc.ClientUnaryCall;
    prepare(input: PrepareJobRequest, metadata: grpc.Metadata, callback: (err: grpc.ServiceError | null, value?: PrepareJobResponse) => void): grpc.ClientUnaryCall;
    prepare(input: PrepareJobRequest, options: grpc.CallOptions, callback: (err: grpc.ServiceError | null, value?: PrepareJobResponse) => void): grpc.ClientUnaryCall;
    prepare(input: PrepareJobRequest, callback: (err: grpc.ServiceError | null, value?: PrepareJobResponse) => void): grpc.ClientUnaryCall;
    /**
     * Submit the job for execution
     *
     * @generated from protobuf rpc: Run(org.apache.beam.model.job_management.v1.RunJobRequest) returns (org.apache.beam.model.job_management.v1.RunJobResponse);
     */
    run(input: RunJobRequest, metadata: grpc.Metadata, options: grpc.CallOptions, callback: (err: grpc.ServiceError | null, value?: RunJobResponse) => void): grpc.ClientUnaryCall;
    run(input: RunJobRequest, metadata: grpc.Metadata, callback: (err: grpc.ServiceError | null, value?: RunJobResponse) => void): grpc.ClientUnaryCall;
    run(input: RunJobRequest, options: grpc.CallOptions, callback: (err: grpc.ServiceError | null, value?: RunJobResponse) => void): grpc.ClientUnaryCall;
    run(input: RunJobRequest, callback: (err: grpc.ServiceError | null, value?: RunJobResponse) => void): grpc.ClientUnaryCall;
    /**
     * Get a list of all invoked jobs
     *
     * @generated from protobuf rpc: GetJobs(org.apache.beam.model.job_management.v1.GetJobsRequest) returns (org.apache.beam.model.job_management.v1.GetJobsResponse);
     */
    getJobs(input: GetJobsRequest, metadata: grpc.Metadata, options: grpc.CallOptions, callback: (err: grpc.ServiceError | null, value?: GetJobsResponse) => void): grpc.ClientUnaryCall;
    getJobs(input: GetJobsRequest, metadata: grpc.Metadata, callback: (err: grpc.ServiceError | null, value?: GetJobsResponse) => void): grpc.ClientUnaryCall;
    getJobs(input: GetJobsRequest, options: grpc.CallOptions, callback: (err: grpc.ServiceError | null, value?: GetJobsResponse) => void): grpc.ClientUnaryCall;
    getJobs(input: GetJobsRequest, callback: (err: grpc.ServiceError | null, value?: GetJobsResponse) => void): grpc.ClientUnaryCall;
    /**
     * Get the current state of the job
     *
     * @generated from protobuf rpc: GetState(org.apache.beam.model.job_management.v1.GetJobStateRequest) returns (org.apache.beam.model.job_management.v1.JobStateEvent);
     */
    getState(input: GetJobStateRequest, metadata: grpc.Metadata, options: grpc.CallOptions, callback: (err: grpc.ServiceError | null, value?: JobStateEvent) => void): grpc.ClientUnaryCall;
    getState(input: GetJobStateRequest, metadata: grpc.Metadata, callback: (err: grpc.ServiceError | null, value?: JobStateEvent) => void): grpc.ClientUnaryCall;
    getState(input: GetJobStateRequest, options: grpc.CallOptions, callback: (err: grpc.ServiceError | null, value?: JobStateEvent) => void): grpc.ClientUnaryCall;
    getState(input: GetJobStateRequest, callback: (err: grpc.ServiceError | null, value?: JobStateEvent) => void): grpc.ClientUnaryCall;
    /**
     * Get the job's pipeline
     *
     * @generated from protobuf rpc: GetPipeline(org.apache.beam.model.job_management.v1.GetJobPipelineRequest) returns (org.apache.beam.model.job_management.v1.GetJobPipelineResponse);
     */
    getPipeline(input: GetJobPipelineRequest, metadata: grpc.Metadata, options: grpc.CallOptions, callback: (err: grpc.ServiceError | null, value?: GetJobPipelineResponse) => void): grpc.ClientUnaryCall;
    getPipeline(input: GetJobPipelineRequest, metadata: grpc.Metadata, callback: (err: grpc.ServiceError | null, value?: GetJobPipelineResponse) => void): grpc.ClientUnaryCall;
    getPipeline(input: GetJobPipelineRequest, options: grpc.CallOptions, callback: (err: grpc.ServiceError | null, value?: GetJobPipelineResponse) => void): grpc.ClientUnaryCall;
    getPipeline(input: GetJobPipelineRequest, callback: (err: grpc.ServiceError | null, value?: GetJobPipelineResponse) => void): grpc.ClientUnaryCall;
    /**
     * Cancel the job
     *
     * @generated from protobuf rpc: Cancel(org.apache.beam.model.job_management.v1.CancelJobRequest) returns (org.apache.beam.model.job_management.v1.CancelJobResponse);
     */
    cancel(input: CancelJobRequest, metadata: grpc.Metadata, options: grpc.CallOptions, callback: (err: grpc.ServiceError | null, value?: CancelJobResponse) => void): grpc.ClientUnaryCall;
    cancel(input: CancelJobRequest, metadata: grpc.Metadata, callback: (err: grpc.ServiceError | null, value?: CancelJobResponse) => void): grpc.ClientUnaryCall;
    cancel(input: CancelJobRequest, options: grpc.CallOptions, callback: (err: grpc.ServiceError | null, value?: CancelJobResponse) => void): grpc.ClientUnaryCall;
    cancel(input: CancelJobRequest, callback: (err: grpc.ServiceError | null, value?: CancelJobResponse) => void): grpc.ClientUnaryCall;
    /**
     * Subscribe to a stream of state changes of the job, will immediately return the current state of the job as the first response.
     *
     * @generated from protobuf rpc: GetStateStream(org.apache.beam.model.job_management.v1.GetJobStateRequest) returns (stream org.apache.beam.model.job_management.v1.JobStateEvent);
     */
    getStateStream(input: GetJobStateRequest, metadata?: grpc.Metadata, options?: grpc.CallOptions): grpc.ClientReadableStream<JobStateEvent>;
    getStateStream(input: GetJobStateRequest, options?: grpc.CallOptions): grpc.ClientReadableStream<JobStateEvent>;
    /**
     * Subscribe to a stream of state changes and messages from the job
     *
     * @generated from protobuf rpc: GetMessageStream(org.apache.beam.model.job_management.v1.JobMessagesRequest) returns (stream org.apache.beam.model.job_management.v1.JobMessagesResponse);
     */
    getMessageStream(input: JobMessagesRequest, metadata?: grpc.Metadata, options?: grpc.CallOptions): grpc.ClientReadableStream<JobMessagesResponse>;
    getMessageStream(input: JobMessagesRequest, options?: grpc.CallOptions): grpc.ClientReadableStream<JobMessagesResponse>;
    /**
     * Fetch metrics for a given job
     *
     * @generated from protobuf rpc: GetJobMetrics(org.apache.beam.model.job_management.v1.GetJobMetricsRequest) returns (org.apache.beam.model.job_management.v1.GetJobMetricsResponse);
     */
    getJobMetrics(input: GetJobMetricsRequest, metadata: grpc.Metadata, options: grpc.CallOptions, callback: (err: grpc.ServiceError | null, value?: GetJobMetricsResponse) => void): grpc.ClientUnaryCall;
    getJobMetrics(input: GetJobMetricsRequest, metadata: grpc.Metadata, callback: (err: grpc.ServiceError | null, value?: GetJobMetricsResponse) => void): grpc.ClientUnaryCall;
    getJobMetrics(input: GetJobMetricsRequest, options: grpc.CallOptions, callback: (err: grpc.ServiceError | null, value?: GetJobMetricsResponse) => void): grpc.ClientUnaryCall;
    getJobMetrics(input: GetJobMetricsRequest, callback: (err: grpc.ServiceError | null, value?: GetJobMetricsResponse) => void): grpc.ClientUnaryCall;
    /**
     * Get the supported pipeline options of the runner
     *
     * @generated from protobuf rpc: DescribePipelineOptions(org.apache.beam.model.job_management.v1.DescribePipelineOptionsRequest) returns (org.apache.beam.model.job_management.v1.DescribePipelineOptionsResponse);
     */
    describePipelineOptions(input: DescribePipelineOptionsRequest, metadata: grpc.Metadata, options: grpc.CallOptions, callback: (err: grpc.ServiceError | null, value?: DescribePipelineOptionsResponse) => void): grpc.ClientUnaryCall;
    describePipelineOptions(input: DescribePipelineOptionsRequest, metadata: grpc.Metadata, callback: (err: grpc.ServiceError | null, value?: DescribePipelineOptionsResponse) => void): grpc.ClientUnaryCall;
    describePipelineOptions(input: DescribePipelineOptionsRequest, options: grpc.CallOptions, callback: (err: grpc.ServiceError | null, value?: DescribePipelineOptionsResponse) => void): grpc.ClientUnaryCall;
    describePipelineOptions(input: DescribePipelineOptionsRequest, callback: (err: grpc.ServiceError | null, value?: DescribePipelineOptionsResponse) => void): grpc.ClientUnaryCall;
}
/**
 * Job Service for running RunnerAPI pipelines
 *
 * @generated from protobuf service org.apache.beam.model.job_management.v1.JobService
 */
export class JobServiceClient extends grpc.Client implements IJobServiceClient {
    private readonly _binaryOptions: Partial<BinaryReadOptions & BinaryWriteOptions>;
    constructor(address: string, credentials: grpc.ChannelCredentials, options: grpc.ClientOptions = {}, binaryOptions: Partial<BinaryReadOptions & BinaryWriteOptions> = {}) {
        super(address, credentials, options);
        this._binaryOptions = binaryOptions;
    }
    /**
     * Prepare a job for execution. The job will not be executed until a call is made to run with the
     * returned preparationId.
     *
     * @generated from protobuf rpc: Prepare(org.apache.beam.model.job_management.v1.PrepareJobRequest) returns (org.apache.beam.model.job_management.v1.PrepareJobResponse);
     */
    prepare(input: PrepareJobRequest, metadata: grpc.Metadata | grpc.CallOptions | ((err: grpc.ServiceError | null, value?: PrepareJobResponse) => void), options?: grpc.CallOptions | ((err: grpc.ServiceError | null, value?: PrepareJobResponse) => void), callback?: ((err: grpc.ServiceError | null, value?: PrepareJobResponse) => void)): grpc.ClientUnaryCall {
        const method = JobService.methods[0];
        return this.makeUnaryRequest<PrepareJobRequest, PrepareJobResponse>(`/${JobService.typeName}/${method.name}`, (value: PrepareJobRequest): Buffer => Buffer.from(method.I.toBinary(value, this._binaryOptions)), (value: Buffer): PrepareJobResponse => method.O.fromBinary(value, this._binaryOptions), input, (metadata as any), (options as any), (callback as any));
    }
    /**
     * Submit the job for execution
     *
     * @generated from protobuf rpc: Run(org.apache.beam.model.job_management.v1.RunJobRequest) returns (org.apache.beam.model.job_management.v1.RunJobResponse);
     */
    run(input: RunJobRequest, metadata: grpc.Metadata | grpc.CallOptions | ((err: grpc.ServiceError | null, value?: RunJobResponse) => void), options?: grpc.CallOptions | ((err: grpc.ServiceError | null, value?: RunJobResponse) => void), callback?: ((err: grpc.ServiceError | null, value?: RunJobResponse) => void)): grpc.ClientUnaryCall {
        const method = JobService.methods[1];
        return this.makeUnaryRequest<RunJobRequest, RunJobResponse>(`/${JobService.typeName}/${method.name}`, (value: RunJobRequest): Buffer => Buffer.from(method.I.toBinary(value, this._binaryOptions)), (value: Buffer): RunJobResponse => method.O.fromBinary(value, this._binaryOptions), input, (metadata as any), (options as any), (callback as any));
    }
    /**
     * Get a list of all invoked jobs
     *
     * @generated from protobuf rpc: GetJobs(org.apache.beam.model.job_management.v1.GetJobsRequest) returns (org.apache.beam.model.job_management.v1.GetJobsResponse);
     */
    getJobs(input: GetJobsRequest, metadata: grpc.Metadata | grpc.CallOptions | ((err: grpc.ServiceError | null, value?: GetJobsResponse) => void), options?: grpc.CallOptions | ((err: grpc.ServiceError | null, value?: GetJobsResponse) => void), callback?: ((err: grpc.ServiceError | null, value?: GetJobsResponse) => void)): grpc.ClientUnaryCall {
        const method = JobService.methods[2];
        return this.makeUnaryRequest<GetJobsRequest, GetJobsResponse>(`/${JobService.typeName}/${method.name}`, (value: GetJobsRequest): Buffer => Buffer.from(method.I.toBinary(value, this._binaryOptions)), (value: Buffer): GetJobsResponse => method.O.fromBinary(value, this._binaryOptions), input, (metadata as any), (options as any), (callback as any));
    }
    /**
     * Get the current state of the job
     *
     * @generated from protobuf rpc: GetState(org.apache.beam.model.job_management.v1.GetJobStateRequest) returns (org.apache.beam.model.job_management.v1.JobStateEvent);
     */
    getState(input: GetJobStateRequest, metadata: grpc.Metadata | grpc.CallOptions | ((err: grpc.ServiceError | null, value?: JobStateEvent) => void), options?: grpc.CallOptions | ((err: grpc.ServiceError | null, value?: JobStateEvent) => void), callback?: ((err: grpc.ServiceError | null, value?: JobStateEvent) => void)): grpc.ClientUnaryCall {
        const method = JobService.methods[3];
        return this.makeUnaryRequest<GetJobStateRequest, JobStateEvent>(`/${JobService.typeName}/${method.name}`, (value: GetJobStateRequest): Buffer => Buffer.from(method.I.toBinary(value, this._binaryOptions)), (value: Buffer): JobStateEvent => method.O.fromBinary(value, this._binaryOptions), input, (metadata as any), (options as any), (callback as any));
    }
    /**
     * Get the job's pipeline
     *
     * @generated from protobuf rpc: GetPipeline(org.apache.beam.model.job_management.v1.GetJobPipelineRequest) returns (org.apache.beam.model.job_management.v1.GetJobPipelineResponse);
     */
    getPipeline(input: GetJobPipelineRequest, metadata: grpc.Metadata | grpc.CallOptions | ((err: grpc.ServiceError | null, value?: GetJobPipelineResponse) => void), options?: grpc.CallOptions | ((err: grpc.ServiceError | null, value?: GetJobPipelineResponse) => void), callback?: ((err: grpc.ServiceError | null, value?: GetJobPipelineResponse) => void)): grpc.ClientUnaryCall {
        const method = JobService.methods[4];
        return this.makeUnaryRequest<GetJobPipelineRequest, GetJobPipelineResponse>(`/${JobService.typeName}/${method.name}`, (value: GetJobPipelineRequest): Buffer => Buffer.from(method.I.toBinary(value, this._binaryOptions)), (value: Buffer): GetJobPipelineResponse => method.O.fromBinary(value, this._binaryOptions), input, (metadata as any), (options as any), (callback as any));
    }
    /**
     * Cancel the job
     *
     * @generated from protobuf rpc: Cancel(org.apache.beam.model.job_management.v1.CancelJobRequest) returns (org.apache.beam.model.job_management.v1.CancelJobResponse);
     */
    cancel(input: CancelJobRequest, metadata: grpc.Metadata | grpc.CallOptions | ((err: grpc.ServiceError | null, value?: CancelJobResponse) => void), options?: grpc.CallOptions | ((err: grpc.ServiceError | null, value?: CancelJobResponse) => void), callback?: ((err: grpc.ServiceError | null, value?: CancelJobResponse) => void)): grpc.ClientUnaryCall {
        const method = JobService.methods[5];
        return this.makeUnaryRequest<CancelJobRequest, CancelJobResponse>(`/${JobService.typeName}/${method.name}`, (value: CancelJobRequest): Buffer => Buffer.from(method.I.toBinary(value, this._binaryOptions)), (value: Buffer): CancelJobResponse => method.O.fromBinary(value, this._binaryOptions), input, (metadata as any), (options as any), (callback as any));
    }
    /**
     * Subscribe to a stream of state changes of the job, will immediately return the current state of the job as the first response.
     *
     * @generated from protobuf rpc: GetStateStream(org.apache.beam.model.job_management.v1.GetJobStateRequest) returns (stream org.apache.beam.model.job_management.v1.JobStateEvent);
     */
    getStateStream(input: GetJobStateRequest, metadata?: grpc.Metadata | grpc.CallOptions, options?: grpc.CallOptions): grpc.ClientReadableStream<JobStateEvent> {
        const method = JobService.methods[6];
        return this.makeServerStreamRequest<GetJobStateRequest, JobStateEvent>(`/${JobService.typeName}/${method.name}`, (value: GetJobStateRequest): Buffer => Buffer.from(method.I.toBinary(value, this._binaryOptions)), (value: Buffer): JobStateEvent => method.O.fromBinary(value, this._binaryOptions), input, (metadata as any), options);
    }
    /**
     * Subscribe to a stream of state changes and messages from the job
     *
     * @generated from protobuf rpc: GetMessageStream(org.apache.beam.model.job_management.v1.JobMessagesRequest) returns (stream org.apache.beam.model.job_management.v1.JobMessagesResponse);
     */
    getMessageStream(input: JobMessagesRequest, metadata?: grpc.Metadata | grpc.CallOptions, options?: grpc.CallOptions): grpc.ClientReadableStream<JobMessagesResponse> {
        const method = JobService.methods[7];
        return this.makeServerStreamRequest<JobMessagesRequest, JobMessagesResponse>(`/${JobService.typeName}/${method.name}`, (value: JobMessagesRequest): Buffer => Buffer.from(method.I.toBinary(value, this._binaryOptions)), (value: Buffer): JobMessagesResponse => method.O.fromBinary(value, this._binaryOptions), input, (metadata as any), options);
    }
    /**
     * Fetch metrics for a given job
     *
     * @generated from protobuf rpc: GetJobMetrics(org.apache.beam.model.job_management.v1.GetJobMetricsRequest) returns (org.apache.beam.model.job_management.v1.GetJobMetricsResponse);
     */
    getJobMetrics(input: GetJobMetricsRequest, metadata: grpc.Metadata | grpc.CallOptions | ((err: grpc.ServiceError | null, value?: GetJobMetricsResponse) => void), options?: grpc.CallOptions | ((err: grpc.ServiceError | null, value?: GetJobMetricsResponse) => void), callback?: ((err: grpc.ServiceError | null, value?: GetJobMetricsResponse) => void)): grpc.ClientUnaryCall {
        const method = JobService.methods[8];
        return this.makeUnaryRequest<GetJobMetricsRequest, GetJobMetricsResponse>(`/${JobService.typeName}/${method.name}`, (value: GetJobMetricsRequest): Buffer => Buffer.from(method.I.toBinary(value, this._binaryOptions)), (value: Buffer): GetJobMetricsResponse => method.O.fromBinary(value, this._binaryOptions), input, (metadata as any), (options as any), (callback as any));
    }
    /**
     * Get the supported pipeline options of the runner
     *
     * @generated from protobuf rpc: DescribePipelineOptions(org.apache.beam.model.job_management.v1.DescribePipelineOptionsRequest) returns (org.apache.beam.model.job_management.v1.DescribePipelineOptionsResponse);
     */
    describePipelineOptions(input: DescribePipelineOptionsRequest, metadata: grpc.Metadata | grpc.CallOptions | ((err: grpc.ServiceError | null, value?: DescribePipelineOptionsResponse) => void), options?: grpc.CallOptions | ((err: grpc.ServiceError | null, value?: DescribePipelineOptionsResponse) => void), callback?: ((err: grpc.ServiceError | null, value?: DescribePipelineOptionsResponse) => void)): grpc.ClientUnaryCall {
        const method = JobService.methods[9];
        return this.makeUnaryRequest<DescribePipelineOptionsRequest, DescribePipelineOptionsResponse>(`/${JobService.typeName}/${method.name}`, (value: DescribePipelineOptionsRequest): Buffer => Buffer.from(method.I.toBinary(value, this._binaryOptions)), (value: Buffer): DescribePipelineOptionsResponse => method.O.fromBinary(value, this._binaryOptions), input, (metadata as any), (options as any), (callback as any));
    }
}
