/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadRegistry {
    private static Logger logger = LoggerFactory.getLogger(ThreadRegistry.class);
    private static ConcurrentMap<Long, ThreadPoolThread> threadPoolMap = new ConcurrentHashMap<Long, ThreadPoolThread>();
    private static ConcurrentMap<String, Integer> threadPoolThreadMap = new ConcurrentHashMap<String, Integer>();

    public static void register(String threadPool) {
        ThreadRegistry.register(threadPool, false);
    }

    public static void register(String threadPool, boolean force) {
        Integer threadPoolThread = threadPoolThreadMap.compute(threadPool, (k, v) -> v == null ? 0 : v + 1);
        if (force) {
            threadPoolMap.remove(Thread.currentThread().getId());
        }
        ThreadRegistry.register(threadPool, threadPoolThread, Thread.currentThread().getId());
    }

    public static void forceClearRegistrationForTests(long threadId) {
        threadPoolMap.compute(threadId, (id, value) -> {
            if (value != null) {
                logger.info("Forcibly clearing registry entry {} for thread id {}", value, id);
            }
            return null;
        });
    }

    public static void register(String threadPool, int threadPoolThread) {
        ThreadRegistry.register(threadPool, threadPoolThread, Thread.currentThread().getId());
    }

    public static void register(String threadPool, int threadPoolThread, long threadId) {
        ThreadPoolThread tpt = new ThreadPoolThread(threadPool, threadPoolThread, threadId);
        ThreadPoolThread previous = threadPoolMap.put(threadId, tpt);
        if (previous != null) {
            throw new IllegalStateException("Thread " + threadId + " was already registered in thread pool " + previous.threadPool + " as thread " + previous.ordinal + " with threadId " + previous.threadId + " trying to overwrite with " + threadPool + " and ordinal " + threadPoolThread);
        }
    }

    public static Runnable registerThread(Runnable runnable, String threadPool) {
        return new RegisteredRunnable(threadPool, runnable);
    }

    public static void clear() {
        threadPoolMap.clear();
        threadPoolThreadMap.clear();
    }

    public static ThreadPoolThread get() {
        return (ThreadPoolThread)threadPoolMap.get(Thread.currentThread().getId());
    }

    private static class RegisteredRunnable
    implements Runnable {
        private final String threadPool;
        private final Runnable runnable;

        public RegisteredRunnable(String threadPool, Runnable runnable) {
            this.threadPool = threadPool;
            this.runnable = runnable;
        }

        @Override
        public void run() {
            ThreadRegistry.register(this.threadPool);
            this.runnable.run();
        }
    }

    public static final class ThreadPoolThread {
        final String threadPool;
        final int ordinal;
        final long threadId;

        public ThreadPoolThread(String threadPool, int ordinal, long threadId) {
            this.threadPool = threadPool;
            this.ordinal = ordinal;
            this.threadId = threadId;
        }

        public String getThreadPool() {
            return this.threadPool;
        }

        public int getOrdinal() {
            return this.ordinal;
        }
    }
}

