/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.BitSet;
import java.util.List;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.ClientContext;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.util.ByteBufList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PendingWriteLacOp
implements BookkeeperInternalCallbacks.WriteLacCallback {
    private static final Logger LOG = LoggerFactory.getLogger(PendingWriteLacOp.class);
    ByteBufList toSend;
    AsyncCallback.AddLacCallback cb;
    long lac;
    Object ctx;
    BitSet receivedResponseSet;
    DistributionSchedule.AckSet ackSet;
    boolean completed = false;
    int lastSeenError = -12;
    LedgerHandle lh;
    ClientContext clientCtx;
    final List<BookieId> currentEnsemble;

    PendingWriteLacOp(LedgerHandle lh, ClientContext clientCtx, List<BookieId> ensemble, AsyncCallback.AddLacCallback cb, Object ctx) {
        this.lh = lh;
        this.clientCtx = clientCtx;
        this.cb = cb;
        this.ctx = ctx;
        this.lac = -1L;
        this.ackSet = lh.distributionSchedule.getAckSet();
        this.currentEnsemble = ensemble;
    }

    void setLac(long lac) {
        this.lac = lac;
        this.receivedResponseSet = new BitSet(this.lh.getLedgerMetadata().getWriteQuorumSize());
        this.receivedResponseSet.set(0, this.lh.getLedgerMetadata().getWriteQuorumSize());
    }

    void sendWriteLacRequest(int bookieIndex) {
        this.clientCtx.getBookieClient().writeLac(this.currentEnsemble.get(bookieIndex), this.lh.ledgerId, this.lh.ledgerKey, this.lac, this.toSend, this, bookieIndex);
    }

    void initiate(ByteBufList toSend) {
        this.toSend = toSend;
        for (int i = 0; i < this.lh.distributionSchedule.getWriteQuorumSize(); ++i) {
            this.sendWriteLacRequest(this.lh.distributionSchedule.getWriteSetBookieIndex(this.lac, i));
        }
    }

    @Override
    public void writeLacComplete(int rc, long ledgerId, BookieId addr, Object ctx) {
        int bookieIndex = (Integer)ctx;
        if (this.completed) {
            return;
        }
        if (0 != rc) {
            this.lastSeenError = rc;
        }
        this.receivedResponseSet.clear(bookieIndex);
        if (rc == 0) {
            if (this.ackSet.completeBookieAndCheck(bookieIndex) && !this.completed) {
                this.completed = true;
                this.cb.addLacComplete(rc, this.lh, ctx);
                return;
            }
        } else {
            LOG.warn("WriteLac did not succeed: Ledger {} on {}", (Object)ledgerId, (Object)addr);
        }
        if (this.receivedResponseSet.isEmpty()) {
            this.completed = true;
            this.cb.addLacComplete(this.lastSeenError, this.lh, ctx);
        }
    }
}

