/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp;

import io.opentelemetry.exporter.internal.marshal.CodedOutputStream;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.proto.common.v1.internal.AnyValue;
import java.io.IOException;

final class BoolAnyValueMarshaler
extends MarshalerWithSize {
    private final boolean value;

    private BoolAnyValueMarshaler(boolean value) {
        super(BoolAnyValueMarshaler.calculateSize(value));
        this.value = value;
    }

    static MarshalerWithSize create(boolean value) {
        return new BoolAnyValueMarshaler(value);
    }

    public void writeTo(Serializer output) throws IOException {
        output.writeBool(AnyValue.BOOL_VALUE, this.value);
    }

    private static int calculateSize(boolean value) {
        return AnyValue.BOOL_VALUE.getTagSize() + CodedOutputStream.computeBoolSizeNoTag((boolean)value);
    }
}

