/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.db;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbClientCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.instrumentation.api.internal.SpanKey;
import io.opentelemetry.instrumentation.api.internal.SpanKeyProvider;
import io.opentelemetry.semconv.DbAttributes;
import io.opentelemetry.semconv.ErrorAttributes;
import javax.annotation.Nullable;

abstract class DbClientCommonAttributesExtractor<REQUEST, RESPONSE, GETTER extends DbClientCommonAttributesGetter<REQUEST, RESPONSE>>
implements AttributesExtractor<REQUEST, RESPONSE>,
SpanKeyProvider {
    private static final AttributeKey<String> DB_NAME = AttributeKey.stringKey((String)"db.name");
    static final AttributeKey<String> DB_SYSTEM = AttributeKey.stringKey((String)"db.system");
    private static final AttributeKey<String> DB_USER = AttributeKey.stringKey((String)"db.user");
    private static final AttributeKey<String> DB_CONNECTION_STRING = AttributeKey.stringKey((String)"db.connection_string");
    final GETTER getter;

    DbClientCommonAttributesExtractor(GETTER getter) {
        this.getter = getter;
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        if (SemconvStability.emitStableDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)DbAttributes.DB_SYSTEM_NAME, (Object)SemconvStability.stableDbSystemName((String)this.getter.getDbSystem(request)));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)DbAttributes.DB_NAMESPACE, (Object)this.getter.getDbNamespace(request));
        }
        if (SemconvStability.emitOldDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_SYSTEM, (Object)this.getter.getDbSystem(request));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_USER, (Object)this.getter.getUser(request));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_NAME, (Object)this.getter.getDbNamespace(request));
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, DB_CONNECTION_STRING, (Object)this.getter.getConnectionString(request));
        }
    }

    public final void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        if (SemconvStability.emitStableDatabaseSemconv()) {
            if (error != null) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)ErrorAttributes.ERROR_TYPE, (Object)error.getClass().getName());
            }
            if (error != null || response != null) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)DbAttributes.DB_RESPONSE_STATUS_CODE, (Object)this.getter.getResponseStatus(response, error));
            }
        }
    }

    public SpanKey internalGetSpanKey() {
        return SpanKey.DB_CLIENT;
    }
}

