/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.set;

import java.util.Iterator;
import org.psjava.ds.map.SetEqualityTester;
import org.psjava.ds.set.MutableSet;
import org.psjava.ds.set.Set;
import org.psjava.util.AssertStatus;
import org.psjava.util.EqualityTester;
import org.psjava.util.IterableToString;
import org.psjava.util.OrderFreeIterableHash;
import org.psjava.util.StrictEqualityTester;

public class MutableSetUsingJavaSet<T>
implements MutableSet<T> {
    private final java.util.Set<T> javaset;

    public MutableSetUsingJavaSet(java.util.Set<T> set) {
        this.javaset = set;
    }

    @Override
    public void clear() {
        this.javaset.clear();
    }

    @Override
    public boolean contains(T v) {
        return this.javaset.contains(v);
    }

    @Override
    public void add(T v) {
        boolean added = this.javaset.add(v);
        AssertStatus.assertTrue(added, "Already exist in set");
    }

    @Override
    public void addIfAbsent(T v) {
        this.javaset.add(v);
    }

    @Override
    public Iterator<T> iterator() {
        return this.javaset.iterator();
    }

    @Override
    public int size() {
        return this.javaset.size();
    }

    @Override
    public void remove(T v) {
        boolean removed = this.javaset.remove(v);
        AssertStatus.assertTrue(removed, "given value is not in set");
    }

    @Override
    public void removeIfExist(T v) {
        this.javaset.remove(v);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        return IterableToString.toString(this);
    }

    public int hashCode() {
        return OrderFreeIterableHash.hash(this);
    }

    public boolean equals(Object obj) {
        return StrictEqualityTester.areEqual(this, obj, new EqualityTester<Set<T>>(){

            @Override
            public boolean areEqual(Set<T> o1, Set<T> o2) {
                return SetEqualityTester.areEqual(o1, o2);
            }
        });
    }
}

