/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.IOException;
import org.apache.cassandra.net.Verb;

class InvalidSerializedSizeException
extends IOException {
    final Verb verb;
    final long expectedSize;
    final long actualSizeAtLeast;

    InvalidSerializedSizeException(Verb verb, long expectedSize, long actualSizeAtLeast) {
        super(String.format("Invalid serialized size; expected %d, actual size at least %d, for verb %s", new Object[]{expectedSize, actualSizeAtLeast, verb}));
        this.verb = verb;
        this.expectedSize = expectedSize;
        this.actualSizeAtLeast = actualSizeAtLeast;
    }

    InvalidSerializedSizeException(long expectedSize, long actualSizeAtLeast) {
        super(String.format("Invalid serialized size; expected %d, actual size at least %d", expectedSize, actualSizeAtLeast));
        this.verb = null;
        this.expectedSize = expectedSize;
        this.actualSizeAtLeast = actualSizeAtLeast;
    }
}

