/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.converter.types.complex;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.cassandra.bridge.BigNumberConfig;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.converter.SparkSqlTypeConverter;
import org.apache.cassandra.spark.data.converter.types.SparkType;
import org.apache.cassandra.spark.data.converter.types.complex.MapFeatures;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.jetbrains.annotations.NotNull;
import scala.collection.JavaConverters;
import scala.collection.Map;

public class SparkMap
implements MapFeatures {
    private final SparkSqlTypeConverter converter;
    private final CqlField.CqlMap map;

    public SparkMap(SparkSqlTypeConverter converter, CqlField.CqlMap map) {
        this.converter = converter;
        this.map = map;
    }

    @Override
    public DataType dataType(BigNumberConfig bigNumberConfig) {
        return DataTypes.createMapType((DataType)this.keyType().dataType(bigNumberConfig), (DataType)this.valueType().dataType(bigNumberConfig));
    }

    @Override
    public Object toSparkSqlType(@NotNull Object value, boolean isFrozen) {
        return this.mapToSparkSqlType((java.util.Map)value, isFrozen);
    }

    private ArrayBasedMapData mapToSparkSqlType(java.util.Map<Object, Object> map, boolean isFrozen) {
        Object[] keys = new Object[map.size()];
        Object[] values = new Object[map.size()];
        int position = 0;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            keys[position] = this.keyType().toSparkSqlType(entry.getKey(), isFrozen);
            values[position] = this.valueType().toSparkSqlType(entry.getValue(), isFrozen);
            ++position;
        }
        return new ArrayBasedMapData(ArrayData.toArrayData((Object)keys), ArrayData.toArrayData((Object)values));
    }

    @Override
    public Object sparkSqlRowValue(GenericInternalRow row, int position) {
        MapData map = row.getMap(position);
        ArrayData keys = map.keyArray();
        ArrayData values = map.valueArray();
        HashMap<Object, Object> result = new HashMap<Object, Object>(keys.numElements());
        for (int element = 0; element < keys.numElements(); ++element) {
            Object key = this.keyType().toTestRowType(keys.get(element, this.keyType().dataType()));
            Object value = this.valueType().toTestRowType(values.get(element, this.valueType().dataType()));
            result.put(key, value);
        }
        return result;
    }

    @Override
    public Object sparkSqlRowValue(Row row, int position) {
        return row.getJavaMap(position).entrySet().stream().collect(Collectors.toMap(element -> this.keyType().toTestRowType(element.getKey()), element -> this.valueType().toTestRowType(element.getValue())));
    }

    @Override
    public Object toTestRowType(Object value) {
        return ((java.util.Map)JavaConverters.mapAsJavaMapConverter((Map)((scala.collection.immutable.Map)value)).asJava()).entrySet().stream().collect(Collectors.toMap(element -> this.keyType().toTestRowType(element.getKey()), element -> this.valueType().toTestRowType(element.getValue())));
    }

    @Override
    public CqlField.CqlCollection collection() {
        return this.map;
    }

    @Override
    public SparkSqlTypeConverter converter() {
        return this.converter;
    }

    @Override
    public boolean equalsTo(Object first, Object second) {
        return SparkType.equalsArrays(((MapData)first).valueArray().array(), ((MapData)second).valueArray().array(), position -> this.valueType());
    }

    @Override
    public int compareTo(Object first, Object second) {
        return SparkType.compareArrays(((MapData)first).valueArray().array(), ((MapData)second).valueArray().array(), position -> this.valueType());
    }
}

