/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.sparksql;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.cassandra.spark.data.DataLayer;
import org.apache.cassandra.spark.sparksql.PartitionSizeScanBuilder;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

class PartitionSizeTable
implements Table,
SupportsRead {
    private final DataLayer dataLayer;
    private final StructType schema;

    PartitionSizeTable(DataLayer dataLayer, StructType schema) {
        this.dataLayer = dataLayer;
        this.schema = schema;
    }

    public String name() {
        return this.dataLayer.cqlTable().keyspace() + "." + this.dataLayer.cqlTable().table();
    }

    public StructType schema() {
        return this.schema;
    }

    public Set<TableCapability> capabilities() {
        return ImmutableSet.of((Object)TableCapability.BATCH_READ);
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
        return new PartitionSizeScanBuilder(this.dataLayer, this.schema, options);
    }
}

