/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.bridge;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.cassandra.bridge.CassandraVersionFeatures;

public enum CassandraVersion {
    THREEZERO(30, "3.0", "three-zero", "big"),
    FOURZERO(40, "4.0", "four-zero", "big"),
    FOURONE(41, "4.1", "four-zero", "big"),
    FIVEZERO(50, "5.0", "five-zero", "big", "bti");

    private final int number;
    private final String name;
    private final String jarBaseName;
    private final Set<String> sstableFormats;
    private static final String sstableFormat;
    private static final CassandraVersion[] implementedVersions;
    private static final String[] supportedVersions;

    private CassandraVersion(int number, String name, String jarBaseName, String ... sstableFormats) {
        this.number = number;
        this.name = name;
        this.jarBaseName = jarBaseName;
        this.sstableFormats = new HashSet<String>(Arrays.asList(sstableFormats));
    }

    public int versionNumber() {
        return this.number;
    }

    public String versionName() {
        return this.name;
    }

    public String jarBaseName() {
        return this.jarBaseName;
    }

    public static String sstableFormat() {
        return sstableFormat;
    }

    public static Optional<CassandraVersion> fromVersion(String cassandraVersion) {
        CassandraVersionFeatures features = CassandraVersionFeatures.cassandraVersionFeaturesFromCassandraVersion(cassandraVersion);
        return Arrays.stream(CassandraVersion.values()).filter(value -> value.versionNumber() == features.getMajorVersion()).findAny();
    }

    public static CassandraVersion[] implementedVersions() {
        return implementedVersions;
    }

    @VisibleForTesting
    public static String[] supportedVersions() {
        return supportedVersions;
    }

    static {
        sstableFormat = System.getProperty("cassandra.analytics.bridges.sstable_format", "big");
        String providedVersionsOrDefault = System.getProperty("cassandra.analytics.bridges.implemented_versions", String.join((CharSequence)",", FOURZERO.name(), FIVEZERO.name()));
        implementedVersions = (CassandraVersion[])Arrays.stream(providedVersionsOrDefault.split(",")).map(CassandraVersion::valueOf).filter(v -> v.sstableFormats.contains(sstableFormat)).toArray(CassandraVersion[]::new);
        String providedSupportedVersionsOrDefault = System.getProperty("cassandra.analytics.bridges.supported_versions", "cassandra-4.0.17,cassandra-5.0.5");
        supportedVersions = (String[])Arrays.stream(providedSupportedVersionsOrDefault.split(",")).filter(version -> CassandraVersion.fromVersion(version).filter(v -> v.sstableFormats.contains(sstableFormat)).isPresent()).toArray(String[]::new);
        Preconditions.checkArgument((implementedVersions.length > 0 && supportedVersions.length > 0 ? 1 : 0) != 0, (Object)"No versions available");
    }
}

