/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.cassandra.auth.MutualTlsCertificateValidator;
import org.apache.cassandra.exceptions.AuthenticationException;

public class SpiffeCertificateValidator
implements MutualTlsCertificateValidator {
    @Override
    public boolean isValidCertificate(Certificate[] clientCertificateChain) {
        return true;
    }

    @Override
    public String identity(Certificate[] clientCertificateChain) throws AuthenticationException {
        try {
            return SpiffeCertificateValidator.getSANSpiffe(clientCertificateChain);
        }
        catch (CertificateException e) {
            throw new AuthenticationException(e.getMessage(), e);
        }
    }

    private static String getSANSpiffe(Certificate[] clientCertificates) throws CertificateException {
        int URI_TYPE = 6;
        X509Certificate[] castedCerts = SpiffeCertificateValidator.castCertsToX509(clientCertificates);
        Collection<List<?>> subjectAltNames = castedCerts[0].getSubjectAlternativeNames();
        if (subjectAltNames != null) {
            for (List<?> item : subjectAltNames) {
                Integer type = (Integer)item.get(0);
                String spiffe = (String)item.get(1);
                if (type != URI_TYPE || !spiffe.startsWith("spiffe://")) continue;
                return spiffe;
            }
        }
        throw new CertificateException("Unable to extract Spiffe from the certificate");
    }

    private static X509Certificate[] castCertsToX509(Certificate[] clientCertificateChain) {
        return Arrays.asList(clientCertificateChain).toArray(new X509Certificate[0]);
    }
}

