/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.memtable;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.memtable.AbstractAllocatorMemtable;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.db.memtable.ShardBoundaries;
import org.apache.cassandra.db.memtable.ShardedMemtableConfigMXBean;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MBeanWrapper;
import org.github.jamm.Unmetered;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractShardedMemtable
extends AbstractAllocatorMemtable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractShardedMemtable.class);
    public static final String SHARDS_OPTION = "shards";
    public static final String SHARDED_MEMTABLE_CONFIG_OBJECT_NAME = "org.apache.cassandra.db:type=ShardedMemtableConfig";
    private static volatile int defaultShardCount;
    @Unmetered
    protected final ShardBoundaries boundaries;

    AbstractShardedMemtable(AtomicReference<CommitLogPosition> commitLogLowerBound, TableMetadataRef metadataRef, Memtable.Owner owner, Integer shardCountOption) {
        super(commitLogLowerBound, metadataRef, owner);
        int shardCount = shardCountOption != null ? shardCountOption : defaultShardCount;
        this.boundaries = owner.localRangeSplits(shardCount);
    }

    public static int getDefaultShardCount() {
        return defaultShardCount;
    }

    static {
        MBeanWrapper.instance.registerMBean((Object)new ShardedMemtableConfig(), SHARDED_MEMTABLE_CONFIG_OBJECT_NAME, MBeanWrapper.OnException.LOG);
        defaultShardCount = CassandraRelevantProperties.MEMTABLE_SHARD_COUNT.getInt(FBUtilities.getAvailableProcessors());
    }

    private static class ShardedMemtableConfig
    implements ShardedMemtableConfigMXBean {
        private ShardedMemtableConfig() {
        }

        @Override
        public void setDefaultShardCount(String shardCount) {
            if ("auto".equalsIgnoreCase(shardCount)) {
                defaultShardCount = FBUtilities.getAvailableProcessors();
            } else {
                try {
                    defaultShardCount = Integer.parseInt(shardCount);
                }
                catch (NumberFormatException ex) {
                    logger.warn("Unable to parse {} as valid value for shard count", (Object)shardCount);
                    return;
                }
            }
            logger.info("Requested setting shard count to {}; set to: {}", (Object)shardCount, (Object)defaultShardCount);
        }

        @Override
        public String getDefaultShardCount() {
            return Integer.toString(defaultShardCount);
        }
    }
}

