/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.io.DataInput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.ExcludingBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.IPartitionerDependentSerializer;
import org.apache.cassandra.dht.IncludingExcludingBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.Pair;

public abstract class AbstractBounds<T extends RingPosition<T>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final IPartitionerDependentSerializer<AbstractBounds<Token>> tokenSerializer = new AbstractBoundsSerializer<Token>(Token.serializer);
    public static final IPartitionerDependentSerializer<AbstractBounds<PartitionPosition>> rowPositionSerializer = new AbstractBoundsSerializer<PartitionPosition>(PartitionPosition.serializer);
    public final T left;
    public final T right;

    public AbstractBounds(T left, T right) {
        assert (left.getPartitioner() == right.getPartitioner());
        this.left = left;
        this.right = right;
    }

    public abstract Pair<AbstractBounds<T>, AbstractBounds<T>> split(T var1);

    public abstract boolean inclusiveLeft();

    public abstract boolean inclusiveRight();

    public static <T extends RingPosition<T>> boolean strictlyWrapsAround(T left, T right) {
        return left.compareTo(right) > 0 && !right.isMinimum();
    }

    public static <T extends RingPosition<T>> boolean noneStrictlyWrapsAround(Collection<AbstractBounds<T>> bounds) {
        for (AbstractBounds<T> b : bounds) {
            if (!AbstractBounds.strictlyWrapsAround(b.left, b.right)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return 31 * this.left.hashCode() + this.right.hashCode();
    }

    public boolean intersects(Iterable<Range<T>> ranges) {
        for (Range<T> range2 : ranges) {
            if (!range2.intersects(this)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean contains(T var1);

    public abstract List<? extends AbstractBounds<T>> unwrap();

    public String getString(AbstractType<?> keyValidator) {
        return this.getOpeningString() + this.format(this.left, keyValidator) + ", " + this.format(this.right, keyValidator) + this.getClosingString();
    }

    private String format(T value, AbstractType<?> keyValidator) {
        if (value instanceof DecoratedKey) {
            return keyValidator.getString(((DecoratedKey)value).getKey());
        }
        return value.toString();
    }

    protected abstract String getOpeningString();

    protected abstract String getClosingString();

    public abstract boolean isStartInclusive();

    public abstract boolean isEndInclusive();

    public abstract AbstractBounds<T> withNewRight(T var1);

    public static <T extends RingPosition<T>> AbstractBounds<T> bounds(Boundary<T> min2, Boundary<T> max) {
        return AbstractBounds.bounds(min2.boundary, min2.inclusive, max.boundary, max.inclusive);
    }

    public static <T extends RingPosition<T>> AbstractBounds<T> bounds(T min2, boolean inclusiveMin, T max, boolean inclusiveMax) {
        if (inclusiveMin && inclusiveMax) {
            return new Bounds<T>(min2, max);
        }
        if (inclusiveMax) {
            return new Range<T>(min2, max);
        }
        if (inclusiveMin) {
            return new IncludingExcludingBounds<T>(min2, max);
        }
        return new ExcludingBounds<T>(min2, max);
    }

    public Boundary<T> leftBoundary() {
        return new Boundary<T>(this.left, this.inclusiveLeft());
    }

    public Boundary<T> rightBoundary() {
        return new Boundary<T>(this.right, this.inclusiveRight());
    }

    public static <T extends RingPosition<T>> boolean isEmpty(Boundary<T> left, Boundary<T> right) {
        int c = left.boundary.compareTo(right.boundary);
        return c > 0 || c == 0 && (!left.inclusive || !right.inclusive);
    }

    public static <T extends RingPosition<T>> Boundary<T> minRight(Boundary<T> right1, T right2, boolean isInclusiveRight2) {
        return AbstractBounds.minRight(right1, new Boundary<T>(right2, isInclusiveRight2));
    }

    public static <T extends RingPosition<T>> Boundary<T> minRight(Boundary<T> right1, Boundary<T> right2) {
        int c = right1.boundary.compareTo(right2.boundary);
        if (c != 0) {
            return c < 0 ? right1 : right2;
        }
        return right2.inclusive ? right1 : right2;
    }

    public static <T extends RingPosition<T>> Boundary<T> maxLeft(Boundary<T> left1, T left2, boolean isInclusiveLeft2) {
        return AbstractBounds.maxLeft(left1, new Boundary<T>(left2, isInclusiveLeft2));
    }

    public static <T extends RingPosition<T>> Boundary<T> maxLeft(Boundary<T> left1, Boundary<T> left2) {
        int c = left1.boundary.compareTo(left2.boundary);
        if (c != 0) {
            return c > 0 ? left1 : left2;
        }
        return left2.inclusive ? left1 : left2;
    }

    public static class Boundary<T extends RingPosition<T>> {
        public final T boundary;
        public final boolean inclusive;

        public Boundary(T boundary, boolean inclusive) {
            this.boundary = boundary;
            this.inclusive = inclusive;
        }
    }

    public static class AbstractBoundsSerializer<T extends RingPosition<T>>
    implements IPartitionerDependentSerializer<AbstractBounds<T>> {
        private static final int IS_TOKEN_FLAG = 1;
        private static final int START_INCLUSIVE_FLAG = 2;
        private static final int END_INCLUSIVE_FLAG = 4;
        IPartitionerDependentSerializer<T> serializer;

        private static int kindInt(AbstractBounds<?> ab) {
            int kind;
            int n = kind = ab instanceof Range ? Type.RANGE.ordinal() : Type.BOUNDS.ordinal();
            if (!(ab.left instanceof Token)) {
                kind = -(kind + 1);
            }
            return kind;
        }

        private static int kindFlags(AbstractBounds<?> ab) {
            int flags = 0;
            if (ab.left instanceof Token) {
                flags |= 1;
            }
            if (ab.isStartInclusive()) {
                flags |= 2;
            }
            if (ab.isEndInclusive()) {
                flags |= 4;
            }
            return flags;
        }

        public AbstractBoundsSerializer(IPartitionerDependentSerializer<T> serializer) {
            this.serializer = serializer;
        }

        @Override
        public void serialize(AbstractBounds<T> range, DataOutputPlus out, int version) throws IOException {
            if (version < 10) {
                out.writeInt(AbstractBoundsSerializer.kindInt(range));
            } else {
                out.writeByte(AbstractBoundsSerializer.kindFlags(range));
            }
            this.serializer.serialize(range.left, out, version);
            this.serializer.serialize(range.right, out, version);
        }

        @Override
        public AbstractBounds<T> deserialize(DataInput in, IPartitioner p, int version) throws IOException {
            boolean endInclusive;
            boolean startInclusive;
            boolean isToken;
            if (version < 10) {
                int kind = in.readInt();
                boolean bl = isToken = kind >= 0;
                if (!isToken) {
                    kind = -(kind + 1);
                }
                startInclusive = kind != Type.RANGE.ordinal();
                endInclusive = true;
            } else {
                int flags = in.readUnsignedByte();
                isToken = (flags & 1) != 0;
                startInclusive = (flags & 2) != 0;
                endInclusive = (flags & 4) != 0;
            }
            RingPosition left = (RingPosition)this.serializer.deserialize(in, p, version);
            RingPosition right = (RingPosition)this.serializer.deserialize(in, p, version);
            assert (isToken == left instanceof Token);
            if (startInclusive) {
                return endInclusive ? new Bounds<RingPosition>(left, right) : new IncludingExcludingBounds<RingPosition>(left, right);
            }
            return endInclusive ? new Range<RingPosition>(left, right) : new ExcludingBounds<RingPosition>(left, right);
        }

        @Override
        public long serializedSize(AbstractBounds<T> ab, int version) {
            int size = version < 10 ? TypeSizes.sizeof(AbstractBoundsSerializer.kindInt(ab)) : 1;
            size = (int)((long)size + this.serializer.serializedSize(ab.left, version));
            size = (int)((long)size + this.serializer.serializedSize(ab.right, version));
            return size;
        }
    }

    private static enum Type {
        RANGE,
        BOUNDS;

    }
}

