/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.bbtree;

import com.carrotsearch.hppc.IntLongHashMap;
import com.carrotsearch.hppc.IntLongMap;
import java.io.IOException;
import org.apache.cassandra.index.sai.disk.io.IndexInputReader;
import org.apache.cassandra.index.sai.disk.v1.SAICodecUtils;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.RandomAccessReader;

class BlockBalancedTreePostingsIndex {
    private final int size;
    public final IntLongMap index = new IntLongHashMap();

    BlockBalancedTreePostingsIndex(FileHandle postingsFileHandle, long filePosition) throws IOException {
        try (RandomAccessReader reader = postingsFileHandle.createReader();
             IndexInputReader input = IndexInputReader.create(reader);){
            SAICodecUtils.validate(input);
            input.seek(filePosition);
            this.size = input.readVInt();
            for (int x = 0; x < this.size; ++x) {
                int node = input.readVInt();
                long filePointer = input.readVLong();
                this.index.put(node, filePointer);
            }
        }
    }

    boolean exists(int nodeID) {
        return this.index.containsKey(nodeID);
    }

    long getPostingsFilePointer(int nodeID) {
        return this.index.get(nodeID);
    }

    int size() {
        return this.size;
    }
}

