/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import java.util.Objects;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.RepairMessage;

public class SnapshotMessage
extends RepairMessage {
    public static final IVersionedSerializer<SnapshotMessage> serializer = new IVersionedSerializer<SnapshotMessage>(){

        @Override
        public void serialize(SnapshotMessage message, DataOutputPlus out, int version) throws IOException {
            RepairJobDesc.serializer.serialize(message.desc, out, version);
        }

        @Override
        public SnapshotMessage deserialize(DataInputPlus in, int version) throws IOException {
            RepairJobDesc desc = (RepairJobDesc)RepairJobDesc.serializer.deserialize(in, version);
            return new SnapshotMessage(desc);
        }

        @Override
        public long serializedSize(SnapshotMessage message, int version) {
            return RepairJobDesc.serializer.serializedSize(message.desc, version);
        }
    };

    public SnapshotMessage(RepairJobDesc desc) {
        super(desc);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SnapshotMessage)) {
            return false;
        }
        SnapshotMessage other = (SnapshotMessage)o;
        return this.desc.equals(other.desc);
    }

    public int hashCode() {
        return Objects.hash(this.desc);
    }
}

