/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;

public abstract class TypeSerializer<T> {
    private static final Pattern PATTERN_SINGLE_QUOTE = Pattern.compile("'", 16);
    private static final String ESCAPED_SINGLE_QUOTE = Matcher.quoteReplacement("'");

    public abstract ByteBuffer serialize(T var1);

    public abstract <V> T deserialize(V var1, ValueAccessor<V> var2);

    public final T deserialize(ByteBuffer bytes) {
        return this.deserialize(bytes, ByteBufferAccessor.instance);
    }

    public abstract <V> void validate(V var1, ValueAccessor<V> var2) throws MarshalException;

    public final void validate(ByteBuffer bytes) throws MarshalException {
        this.validate(bytes, ByteBufferAccessor.instance);
    }

    public abstract String toString(T var1);

    public abstract Class<T> getType();

    public final boolean isNull(@Nullable ByteBuffer buffer) {
        return this.isNull(buffer, ByteBufferAccessor.instance);
    }

    public <V> boolean isNull(@Nullable V buffer, ValueAccessor<V> accessor) {
        return buffer == null || accessor.isEmpty(buffer);
    }

    protected String toCQLLiteralNonNull(@Nonnull ByteBuffer buffer) {
        return this.toString(this.deserialize(buffer));
    }

    @Nonnull
    public final String toCQLLiteral(@Nullable ByteBuffer buffer) {
        return this.isNull(buffer) ? "null" : this.maybeQuote(this.toCQLLiteralNonNull(buffer));
    }

    @Nonnull
    public final String toCQLLiteralNoQuote(@Nullable ByteBuffer buffer) {
        return this.isNull(buffer) ? "null" : this.toCQLLiteralNonNull(buffer);
    }

    public boolean shouldQuoteCQLLiterals() {
        return false;
    }

    private String maybeQuote(String value) {
        if (this.shouldQuoteCQLLiterals()) {
            return "'" + PATTERN_SINGLE_QUOTE.matcher(value).replaceAll(ESCAPED_SINGLE_QUOTE) + "'";
        }
        return value;
    }
}

