/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.concurrent.Condition;
import org.apache.cassandra.utils.progress.ProgressEvent;
import org.apache.cassandra.utils.progress.ProgressEventType;
import org.apache.cassandra.utils.progress.jmx.JMXNotificationProgressListener;

public class BootstrapMonitor
extends JMXNotificationProgressListener {
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    private final PrintStream out;
    private final Condition condition = Condition.newOneTimeCondition();
    private volatile Exception error;

    public BootstrapMonitor(PrintStream out) {
        this.out = out;
    }

    public void awaitCompletion() throws InterruptedException {
        this.condition.await();
    }

    @Override
    public boolean isInterestedIn(String tag) {
        return "bootstrap".equals(tag);
    }

    @Override
    public void handleNotificationLost(long timestamp, String message) {
        super.handleNotificationLost(timestamp, message);
    }

    @Override
    public void handleConnectionClosed(long timestamp, String message) {
        this.handleConnectionFailed(timestamp, message);
    }

    @Override
    public void handleConnectionFailed(long timestamp, String message) {
        this.error = new IOException(String.format("[%s] JMX connection closed. (%s)", this.format.format(timestamp), message));
        this.out.println(this.error.getMessage());
        this.condition.signalAll();
    }

    @Override
    public void progress(String tag, ProgressEvent event) {
        ProgressEventType type = event.getType();
        Object message = String.format("[%s] %s", this.format.format(Clock.Global.currentTimeMillis()), event.getMessage());
        if (type == ProgressEventType.PROGRESS) {
            message = (String)message + " (progress: " + (int)event.getProgressPercentage() + "%)";
        }
        this.out.println((String)message);
        if (type == ProgressEventType.ERROR) {
            this.error = new RuntimeException(String.format("Bootstrap resume has failed with error: %s", message));
            this.condition.signalAll();
        }
        if (type == ProgressEventType.COMPLETE) {
            this.condition.signalAll();
        }
    }

    public Exception getError() {
        return this.error;
    }
}

