/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.gridkit.jvmtool.JmxConnectionInfo;
import org.gridkit.jvmtool.MBeanHelper;
import org.gridkit.jvmtool.MTable;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.jvmtool.cmd.Unsplitter;
import org.gridkit.util.formating.TextTable;

public class MxCmd
implements CommandLauncher.CmdRef {
    @Override
    public String getCommandName() {
        return "mx";
    }

    @Override
    public Runnable newCommand(CommandLauncher host) {
        return new MX(host);
    }

    @Parameters(commandDescription="[MBean] MBean query and invokation")
    public static class MX
    implements Runnable {
        @ParametersDelegate
        private CommandLauncher host;
        @ParametersDelegate
        private JmxConnectionInfo connInfo;
        @Parameter(names={"-b", "--bean"}, required=true, description="MBean name")
        private String mbean;
        @Parameter(names={"-f", "--field", "--attribute"}, description="MBean attribute")
        String attrib = null;
        @Parameter(names={"--quiet"}, description="Avoid non-essential output")
        boolean quiet = false;
        @Parameter(names={"--max-col-width"}, description="Table column width threshold for formating tabular data")
        int maxWidth = 40;
        @ParametersDelegate
        private CallCmd call = new CallCmd();
        @Parameter(names={"-all", "--allMatched"}, description="Process all matched MBeans")
        private boolean all = false;
        @ParametersDelegate
        private GetCmd get = new GetCmd();
        @ParametersDelegate
        private SetCmd set = new SetCmd();
        @ParametersDelegate
        private InfoCmd info = new InfoCmd();

        public MX(CommandLauncher host) {
            this.host = host;
            this.connInfo = new JmxConnectionInfo(host);
        }

        @Override
        public void run() {
            try {
                ArrayList<Runnable> action = new ArrayList<Runnable>();
                if (this.call.run) {
                    action.add(this.call);
                }
                if (this.get.run) {
                    action.add(this.get);
                }
                if (this.set.run) {
                    action.add(this.set);
                }
                if (this.info.run) {
                    action.add(this.info);
                }
                if (action.isEmpty() || action.size() > 1) {
                    this.host.failAndPrintUsage("You should choose one of --info, --get, --set, --call");
                }
                ((Runnable)action.get(0)).run();
            }
            catch (Exception e) {
                this.host.fail(e.toString(), e);
            }
        }

        private Set<ObjectName> resolveSingleBean(MBeanServerConnection conn) throws Exception {
            ObjectName name = new ObjectName(this.mbean);
            Set<ObjectName> beans = conn.queryNames(name, null);
            if (beans.isEmpty()) {
                this.host.fail("MBean not found: " + this.mbean);
            }
            if (!this.all && beans.size() > 1) {
                StringBuilder sb = new StringBuilder();
                for (ObjectName n : beans) {
                    sb.append('\n').append(n);
                }
                this.host.fail("Ambiguous MBean selection. Use '-all' param for process all matched MBeans" + sb.toString());
            }
            return beans;
        }

        class InfoCmd
        implements Runnable {
            @Parameter(names={"-mi", "--info"}, description="Display metadata for MBean")
            boolean run;

            InfoCmd() {
            }

            @Override
            public void run() {
                try {
                    MBeanServerConnection conn = MX.this.connInfo.getMServer();
                    Set names = MX.this.resolveSingleBean(conn);
                    MBeanHelper helper = new MBeanHelper(conn);
                    for (ObjectName name : names) {
                        System.out.println(helper.describe(name));
                    }
                }
                catch (Exception e) {
                    MX.this.host.fail(e.toString(), e);
                }
            }
        }

        class SetCmd
        implements Runnable {
            @Parameter(names={"-ms", "--set"}, description="Sets value for MBean attribute")
            boolean run;
            @Parameter(names={"-v", "--value"}, description="Value to set to attribute")
            String value = null;

            SetCmd() {
            }

            @Override
            public void run() {
                try {
                    if (MX.this.attrib == null) {
                        MX.this.host.failAndPrintUsage("MBean attribute name is missing");
                    }
                    if (this.value == null) {
                        MX.this.host.failAndPrintUsage("Value is required");
                    }
                    MBeanServerConnection conn = MX.this.connInfo.getMServer();
                    Set names = MX.this.resolveSingleBean(conn);
                    MBeanHelper helper = new MBeanHelper(conn);
                    for (ObjectName name : names) {
                        if (!MX.this.quiet) {
                            System.out.println(name);
                        }
                        helper.set(name, MX.this.attrib, this.value);
                    }
                }
                catch (Exception e) {
                    MX.this.host.fail(e.toString(), e);
                }
            }
        }

        class GetCmd
        implements Runnable {
            @Parameter(names={"-mg", "--get"}, description="Retrieves value of MBean attribute")
            boolean run;
            @Parameter(names={"--csv"}, description="Used with --get command, result would be formatted as CSV")
            boolean csv;

            GetCmd() {
            }

            @Override
            public void run() {
                try {
                    if (MX.this.attrib == null) {
                        MX.this.host.failAndPrintUsage("MBean operation name is missing");
                    }
                    MBeanServerConnection conn = MX.this.connInfo.getMServer();
                    Set names = MX.this.resolveSingleBean(conn);
                    MBeanHelper helper = new MBeanHelper(conn);
                    if (this.csv) {
                        MTable table = new MTable();
                        for (ObjectName name : names) {
                            helper.getAsTable(name, MX.this.attrib, table);
                        }
                        if (table.isEmpty()) {
                            System.out.println("No data");
                        } else {
                            TextTable tt = new TextTable();
                            table.export(tt);
                            System.out.println(TextTable.formatCsv(tt));
                        }
                    } else {
                        helper.setFormatingOption(MBeanHelper.FORMAT_TABLE_COLUMN_WIDTH_THRESHOLD, MX.this.maxWidth);
                        for (ObjectName name : names) {
                            if (!MX.this.quiet) {
                                System.out.println(name);
                            }
                            System.out.println(helper.get(name, MX.this.attrib));
                        }
                    }
                }
                catch (Exception e) {
                    MX.this.host.fail(e.toString(), e);
                }
            }
        }

        class CallCmd
        implements Runnable {
            @Parameter(names={"-mc", "--call"}, description="Invokes MBean method")
            boolean run;
            @Parameter(names={"-op", "--operation"}, description="MBean operation name to be called")
            String operation = null;
            @Parameter(names={"-a", "--arguments"}, variableArity=true, splitter=Unsplitter.class, description="Arguments for MBean operation invocation")
            List<String> arguments = new ArrayList<String>();

            CallCmd() {
            }

            @Override
            public void run() {
                try {
                    if (this.operation == null) {
                        MX.this.host.failAndPrintUsage("MBean operation name is missing");
                    }
                    MBeanServerConnection conn = MX.this.connInfo.getMServer();
                    Set names = MX.this.resolveSingleBean(conn);
                    MBeanHelper helper = new MBeanHelper(conn);
                    helper.setFormatingOption(MBeanHelper.FORMAT_TABLE_COLUMN_WIDTH_THRESHOLD, MX.this.maxWidth);
                    for (ObjectName name : names) {
                        if (!MX.this.quiet) {
                            System.out.println(name);
                        }
                        System.out.println(helper.invoke(name, this.operation, this.arguments.toArray(new String[this.arguments.size()])));
                    }
                }
                catch (Exception e) {
                    MX.this.host.fail(e.toString(), e);
                }
            }
        }
    }
}

