/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.Weigher;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Iterator;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.cache.IMeasurableMemory;

public class CaffeineCache<K extends IMeasurableMemory, V extends IMeasurableMemory>
implements ICache<K, V> {
    private final Cache<K, V> cache;
    private final Policy.Eviction<K, V> policy;

    private CaffeineCache(Cache<K, V> cache) {
        this.cache = cache;
        this.policy = cache.policy().eviction().orElseThrow(() -> new IllegalArgumentException("Expected a size bounded cache"));
        Preconditions.checkState(this.policy.isWeighted(), "Expected a weighted cache");
    }

    public static <K extends IMeasurableMemory, V extends IMeasurableMemory> CaffeineCache<K, V> create(long weightedCapacity, Weigher<K, V> weigher) {
        Cache cache = Caffeine.newBuilder().maximumWeight(weightedCapacity).weigher(weigher).executor(MoreExecutors.directExecutor()).build();
        return new CaffeineCache(cache);
    }

    public static <K extends IMeasurableMemory, V extends IMeasurableMemory> CaffeineCache<K, V> create(long weightedCapacity) {
        return CaffeineCache.create(weightedCapacity, (key, value) -> {
            long size = key.unsharedHeapSize() + value.unsharedHeapSize();
            if (size > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Serialized size cannot be more than 2GB/Integer.MAX_VALUE");
            }
            return (int)size;
        });
    }

    @Override
    public long capacity() {
        return this.policy.getMaximum();
    }

    @Override
    public void setCapacity(long capacity) {
        this.policy.setMaximum(capacity);
    }

    public boolean isEmpty() {
        return this.cache.asMap().isEmpty();
    }

    @Override
    public int size() {
        return this.cache.asMap().size();
    }

    @Override
    public long weightedSize() {
        return this.policy.weightedSize().getAsLong();
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    public V get(K key) {
        return (V)((IMeasurableMemory)this.cache.getIfPresent(key));
    }

    @Override
    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    @Override
    public boolean putIfAbsent(K key, V value) {
        return this.cache.asMap().putIfAbsent(key, value) == null;
    }

    @Override
    public boolean replace(K key, V old, V value) {
        return this.cache.asMap().replace(key, old, value);
    }

    @Override
    public void remove(K key) {
        this.cache.invalidate(key);
    }

    @Override
    public Iterator<K> keyIterator() {
        return this.cache.asMap().keySet().iterator();
    }

    @Override
    public Iterator<K> hotKeyIterator(int n) {
        return this.policy.hottest(n).keySet().iterator();
    }

    @Override
    public boolean containsKey(K key) {
        return this.cache.asMap().containsKey(key);
    }
}

