/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.util.function.Predicate;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;

public class InOurDcTester {
    private static ReplicaTester replicas;
    private static EndpointTester endpoints;
    final String dc;
    final IEndpointSnitch snitch;

    private InOurDcTester(String dc, IEndpointSnitch snitch) {
        this.dc = dc;
        this.snitch = snitch;
    }

    boolean stale() {
        return this.dc != DatabaseDescriptor.getLocalDataCenter() || this.snitch != DatabaseDescriptor.getEndpointSnitch() || !this.dc.equals(this.snitch.getLocalDatacenter());
    }

    public static Predicate<Replica> replicas() {
        ReplicaTester cur = replicas;
        if (cur == null || cur.stale()) {
            replicas = cur = new ReplicaTester(DatabaseDescriptor.getLocalDataCenter(), DatabaseDescriptor.getEndpointSnitch());
        }
        return cur;
    }

    public static Predicate<InetAddressAndPort> endpoints() {
        EndpointTester cur = endpoints;
        if (cur == null || cur.stale()) {
            endpoints = cur = new EndpointTester(DatabaseDescriptor.getLocalDataCenter(), DatabaseDescriptor.getEndpointSnitch());
        }
        return cur;
    }

    private static final class EndpointTester
    extends InOurDcTester
    implements Predicate<InetAddressAndPort> {
        private EndpointTester(String dc, IEndpointSnitch snitch) {
            super(dc, snitch);
        }

        @Override
        public boolean test(InetAddressAndPort endpoint) {
            return this.dc.equals(this.snitch.getDatacenter(endpoint));
        }
    }

    private static final class ReplicaTester
    extends InOurDcTester
    implements Predicate<Replica> {
        private ReplicaTester(String dc, IEndpointSnitch snitch) {
            super(dc, snitch);
        }

        @Override
        public boolean test(Replica replica) {
            return this.dc.equals(this.snitch.getDatacenter(replica.endpoint()));
        }
    }
}

