/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.template.directive;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.template.Context;
import org.apache.cayenne.template.directive.Directive;
import org.apache.cayenne.template.parser.ASTExpression;
import org.apache.cayenne.util.Util;

public class Result
implements Directive {
    public static final Result INSTANCE = new Result();
    private static final Map<String, String> typesGuess = new HashMap<String, String>();

    @Override
    public void apply(Context context, ASTExpression ... expressions) {
        ColumnDescriptor columnDescriptor = new ColumnDescriptor();
        String column = expressions[0].evaluateAsString(context);
        columnDescriptor.setName(column);
        if (expressions.length > 1) {
            String type = expressions[1].evaluateAsString(context);
            columnDescriptor.setJavaClass(this.guessType(type));
        }
        String alias = null;
        if (expressions.length > 2) {
            alias = expressions[2].evaluateAsString(context);
        }
        String dataRowKey = null;
        if (expressions.length > 3) {
            dataRowKey = expressions[3].evaluateAsString(context);
        }
        String label = !Util.isEmptyString(dataRowKey) ? dataRowKey : (!Util.isEmptyString(alias) ? alias : null);
        columnDescriptor.setDataRowKey(label);
        if (expressions.length > 4) {
            int jdbcType = (int)expressions[4].evaluateAsLong(context);
            columnDescriptor.setJdbcType(jdbcType);
        }
        context.addColumnDescriptor(columnDescriptor);
        context.getBuilder().append(column);
        if (!Util.isEmptyString(alias) && !alias.equals(column)) {
            context.getBuilder().append(" AS ").append(alias);
        }
    }

    protected String guessType(String type) {
        String guessed = typesGuess.get(type);
        return guessed != null ? guessed : type;
    }

    static {
        typesGuess.put("long", Long.class.getName());
        typesGuess.put("double", Double.class.getName());
        typesGuess.put("byte", Byte.class.getName());
        typesGuess.put("boolean", Boolean.class.getName());
        typesGuess.put("float", Float.class.getName());
        typesGuess.put("short", Short.class.getName());
        typesGuess.put("int", Integer.class.getName());
        typesGuess.put("Long", Long.class.getName());
        typesGuess.put("Double", Double.class.getName());
        typesGuess.put("Byte", Byte.class.getName());
        typesGuess.put("Boolean", Boolean.class.getName());
        typesGuess.put("Float", Float.class.getName());
        typesGuess.put("Short", Short.class.getName());
        typesGuess.put("Integer", Integer.class.getName());
        typesGuess.put("String", String.class.getName());
        typesGuess.put("Date", Date.class.getName());
        typesGuess.put("Time", Time.class.getName());
        typesGuess.put("Timestamp", Timestamp.class.getName());
        typesGuess.put("BigDecimal", BigDecimal.class.getName());
        typesGuess.put("BigInteger", BigInteger.class.getName());
    }
}

