/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelFilter;
import org.apache.cayenne.DataChannelQueryFilter;
import org.apache.cayenne.DataChannelQueryFilterChain;
import org.apache.cayenne.DataChannelSyncFilter;
import org.apache.cayenne.DataChannelSyncFilterChain;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomainLegacyQueryAction;
import org.apache.cayenne.access.DataDomainQueryAction;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.DataRowStoreFactory;
import org.apache.cayenne.access.DomainStoppedException;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryEngine;
import org.apache.cayenne.access.flush.DataDomainFlushAction;
import org.apache.cayenne.access.flush.DataDomainFlushActionFactory;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.BeforeScopeEnd;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryChain;
import org.apache.cayenne.tx.BaseTransaction;
import org.apache.cayenne.tx.Transaction;
import org.apache.cayenne.tx.TransactionManager;
import org.apache.cayenne.util.ToStringBuilder;

public class DataDomain
implements QueryEngine,
DataChannel {
    public static final String SHARED_CACHE_ENABLED_PROPERTY = "cayenne.DataDomain.sharedCache";
    public static final boolean SHARED_CACHE_ENABLED_DEFAULT = true;
    public static final String VALIDATING_OBJECTS_ON_COMMIT_PROPERTY = "cayenne.DataDomain.validatingObjectsOnCommit";
    public static final boolean VALIDATING_OBJECTS_ON_COMMIT_DEFAULT = true;
    @Inject
    protected JdbcEventLogger jdbcEventLogger;
    @Inject
    protected TransactionManager transactionManager;
    protected DataRowStoreFactory dataRowStoreFactory;
    protected int maxIdQualifierSize;
    @Deprecated
    protected List<DataChannelFilter> filters;
    protected List<DataChannelQueryFilter> queryFilters;
    protected List<DataChannelSyncFilter> syncFilters;
    @Inject
    protected DataDomainFlushActionFactory flushActionFactory;
    @Inject
    protected AdhocObjectFactory objectFactory;
    protected Map<String, DataNode> nodes;
    protected Map<String, DataNode> nodesByDataMapName;
    protected DataNode defaultNode;
    protected Map<String, String> properties;
    protected EntityResolver entityResolver;
    protected DataRowStore sharedSnapshotCache;
    protected String name;
    protected QueryCache queryCache;
    protected boolean sharedCacheEnabled;
    protected boolean validatingObjectsOnCommit;
    protected EventManager eventManager;
    protected EntitySorter entitySorter;
    protected boolean stopped;

    public DataDomain(String name) {
        this.init(name);
        this.resetProperties();
    }

    @Deprecated
    public DataDomain(String name, Map<String, String> properties) {
        this.init(name);
        this.initWithProperties(properties);
    }

    private void init(String name) {
        this.queryFilters = new CopyOnWriteArrayList<DataChannelQueryFilter>();
        this.syncFilters = new CopyOnWriteArrayList<DataChannelSyncFilter>();
        this.nodesByDataMapName = new ConcurrentHashMap<String, DataNode>();
        this.nodes = new ConcurrentHashMap<String, DataNode>();
        this.properties = Collections.emptyMap();
        this.setName(name);
    }

    protected void checkStopped() throws DomainStoppedException {
        if (this.stopped) {
            throw new DomainStoppedException("Domain " + this.name + " was shutdown and can no longer be used to access the database", new Object[0]);
        }
    }

    public EntitySorter getEntitySorter() {
        return this.entitySorter;
    }

    public void setEntitySorter(EntitySorter entitySorter) {
        this.entitySorter = entitySorter;
    }

    protected void resetProperties() {
        this.properties = Collections.emptyMap();
        this.sharedCacheEnabled = true;
        this.validatingObjectsOnCommit = true;
    }

    @Deprecated
    public void initWithProperties(Map<String, String> properties) {
        properties = properties != null ? new HashMap<String, String>(properties) : Collections.emptyMap();
        String sharedCacheEnabled = (String)properties.get(SHARED_CACHE_ENABLED_PROPERTY);
        String validatingObjectsOnCommit = (String)properties.get(VALIDATING_OBJECTS_ON_COMMIT_PROPERTY);
        this.sharedCacheEnabled = sharedCacheEnabled != null ? "true".equalsIgnoreCase(sharedCacheEnabled) : true;
        this.validatingObjectsOnCommit = validatingObjectsOnCommit != null ? "true".equalsIgnoreCase(validatingObjectsOnCommit) : true;
        this.properties = properties;
    }

    @Override
    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
        if (this.sharedSnapshotCache != null) {
            this.sharedSnapshotCache.setEventManager(eventManager);
        }
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
        if (this.sharedSnapshotCache != null) {
            this.sharedSnapshotCache.setName(name);
        }
    }

    public boolean isSharedCacheEnabled() {
        return this.sharedCacheEnabled;
    }

    public void setSharedCacheEnabled(boolean sharedCacheEnabled) {
        this.sharedCacheEnabled = sharedCacheEnabled;
    }

    public boolean isValidatingObjectsOnCommit() {
        return this.validatingObjectsOnCommit;
    }

    public void setValidatingObjectsOnCommit(boolean flag) {
        this.validatingObjectsOnCommit = flag;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public DataRowStore getSharedSnapshotCache() {
        if (this.sharedSnapshotCache == null && this.sharedCacheEnabled) {
            this.sharedSnapshotCache = this.nonNullSharedSnapshotCache();
        }
        return this.sharedSnapshotCache;
    }

    synchronized DataRowStore nonNullSharedSnapshotCache() {
        if (this.sharedSnapshotCache == null) {
            this.sharedSnapshotCache = this.dataRowStoreFactory.createDataRowStore(this.name);
        }
        return this.sharedSnapshotCache;
    }

    public synchronized void setSharedSnapshotCache(DataRowStore snapshotCache) {
        if (this.sharedSnapshotCache != snapshotCache) {
            if (this.sharedSnapshotCache != null) {
                this.sharedSnapshotCache.shutdown();
            }
            this.sharedSnapshotCache = snapshotCache;
            if (snapshotCache != null) {
                snapshotCache.setEventManager(this.getEventManager());
                snapshotCache.setName(this.getName());
            }
        }
    }

    public void addDataMap(DataMap dataMap) {
        this.getEntityResolver().addDataMap(dataMap);
        this.refreshEntitySorter();
    }

    public DataMap getDataMap(String mapName) {
        return this.getEntityResolver().getDataMap(mapName);
    }

    public void removeDataMap(String mapName) {
        DataMap map = this.getDataMap(mapName);
        if (map == null) {
            return;
        }
        for (DataNode node : this.nodes.values()) {
            node.removeDataMap(mapName);
        }
        this.nodesByDataMapName.remove(mapName);
        this.getEntityResolver().removeDataMap(map);
        this.refreshEntitySorter();
    }

    public void removeDataNode(String nodeName) {
        DataNode removed = this.nodes.remove(nodeName);
        if (removed != null) {
            removed.setEntityResolver(null);
            this.nodesByDataMapName.values().removeIf(dataNode -> dataNode == removed);
        }
    }

    public Collection<DataMap> getDataMaps() {
        return this.getEntityResolver().getDataMaps();
    }

    public Collection<DataNode> getDataNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    public void addNode(DataNode node) {
        this.nodes.put(node.getName(), node);
        node.setEntityResolver(this.getEntityResolver());
        for (DataMap map : node.getDataMaps()) {
            this.addDataMap(map);
            this.nodesByDataMapName.put(map.getName(), node);
        }
    }

    public DataNode getDataNode(String nodeName) {
        return this.nodes.get(nodeName);
    }

    public DataNode lookupDataNode(DataMap map) {
        DataNode node = this.nodesByDataMapName.get(map.getName());
        if (node == null) {
            for (DataNode n : this.getDataNodes()) {
                for (DataMap m : n.getDataMaps()) {
                    if (m != map) continue;
                    this.nodesByDataMapName.put(map.getName(), n);
                    node = n;
                    break;
                }
                if (node == null) continue;
                break;
            }
            if (node == null) {
                if (this.defaultNode != null) {
                    this.nodesByDataMapName.put(map.getName(), this.defaultNode);
                    node = this.defaultNode;
                } else {
                    throw new CayenneRuntimeException("No DataNode configured for DataMap '%s' and no default DataNode set", map.getName());
                }
            }
        }
        return node;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    private synchronized void createEntityResolver() {
        if (this.entityResolver == null) {
            this.entityResolver = new EntityResolver();
        }
    }

    @BeforeScopeEnd
    public void shutdown() {
        if (!this.stopped) {
            this.stopped = true;
            if (this.sharedSnapshotCache != null) {
                this.sharedSnapshotCache.shutdown();
            }
        }
    }

    @Override
    public void performQueries(Collection<? extends Query> queries, OperationObserver callback) {
        this.transactionManager.performInTransaction(() -> {
            new DataDomainLegacyQueryAction(this, new QueryChain(queries), callback).execute();
            return null;
        });
    }

    @Override
    public QueryResponse onQuery(ObjectContext originatingContext, Query query) {
        this.checkStopped();
        return new DataDomainQueryFilterChain().onQuery(originatingContext, query);
    }

    QueryResponse onQueryNoFilters(ObjectContext originatingContext, Query query) {
        return new DataDomainQueryAction(originatingContext, this, query).execute();
    }

    @Override
    public EntityResolver getEntityResolver() {
        if (this.entityResolver == null) {
            this.createEntityResolver();
        }
        return this.entityResolver;
    }

    @Override
    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
        this.checkStopped();
        return new DataDomainSyncFilterChain().onSync(originatingContext, changes, syncType);
    }

    GraphDiff onSyncNoFilters(ObjectContext originatingContext, GraphDiff changes, int syncType) {
        GraphDiff result;
        switch (syncType) {
            case 3: {
                result = this.onSyncRollback(originatingContext);
                break;
            }
            case 1: 
            case 2: {
                result = this.onSyncFlush(originatingContext, changes);
                break;
            }
            default: {
                throw new CayenneRuntimeException("Invalid synchronization type: %d", syncType);
            }
        }
        return result;
    }

    GraphDiff onSyncRollback(ObjectContext originatingContext) {
        Transaction transaction = BaseTransaction.getThreadTransaction();
        if (transaction != null) {
            transaction.setRollbackOnly();
        }
        return new CompoundDiff();
    }

    GraphDiff onSyncFlush(ObjectContext originatingContext, GraphDiff childChanges) {
        if (!(originatingContext instanceof DataContext)) {
            throw new CayenneRuntimeException("No support for committing ObjectContexts that are not DataContexts yet. Unsupported context: %s", originatingContext);
        }
        DataDomainFlushAction action = this.flushActionFactory.createFlushAction(this);
        return action.flush((DataContext)originatingContext, childChanges);
    }

    public String toString() {
        return new ToStringBuilder(this).append("name", this.name).toString();
    }

    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    public void setQueryCache(QueryCache queryCache) {
        this.queryCache = queryCache;
    }

    public DataRowStoreFactory getDataRowStoreFactory() {
        return this.dataRowStoreFactory;
    }

    public void setDataRowStoreFactory(DataRowStoreFactory dataRowStoreFactory) {
        this.dataRowStoreFactory = dataRowStoreFactory;
    }

    JdbcEventLogger getJdbcEventLogger() {
        return this.jdbcEventLogger;
    }

    void refreshEntitySorter() {
        if (this.entitySorter != null) {
            this.entitySorter.setEntityResolver(this.getEntityResolver());
        }
    }

    @Deprecated
    public List<DataChannelFilter> getFilters() {
        return Collections.emptyList();
    }

    public List<DataChannelQueryFilter> getQueryFilters() {
        return Collections.unmodifiableList(this.queryFilters);
    }

    public List<DataChannelSyncFilter> getSyncFilters() {
        return Collections.unmodifiableList(this.syncFilters);
    }

    @Deprecated
    public void addFilter(DataChannelFilter filter) {
        filter.init(this);
        this.addListener(filter);
        this.queryFilters.add(filter);
        this.syncFilters.add(filter);
    }

    public void addQueryFilter(DataChannelQueryFilter filter) {
        if (!this.syncFilters.contains(filter)) {
            this.addListener(filter);
        }
        this.queryFilters.add(filter);
    }

    public void addSyncFilter(DataChannelSyncFilter filter) {
        if (!this.queryFilters.contains(filter)) {
            this.addListener(filter);
        }
        this.syncFilters.add(filter);
    }

    @Deprecated
    public void removeFilter(DataChannelFilter filter) {
        this.removeQueryFilter(filter);
        this.removeSyncFilter(filter);
    }

    public void removeQueryFilter(DataChannelQueryFilter filter) {
        this.queryFilters.remove(filter);
    }

    public void removeSyncFilter(DataChannelSyncFilter filter) {
        this.syncFilters.remove(filter);
    }

    public void addListener(Object listener) {
        this.getEntityResolver().getCallbackRegistry().addListener(listener);
    }

    public DataNode getDefaultNode() {
        return this.defaultNode;
    }

    public void setDefaultNode(DataNode defaultNode) {
        this.defaultNode = defaultNode;
    }

    public int getMaxIdQualifierSize() {
        return this.maxIdQualifierSize;
    }

    public void setMaxIdQualifierSize(int maxIdQualifierSize) {
        this.maxIdQualifierSize = maxIdQualifierSize;
    }

    TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    AdhocObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    final class DataDomainQueryFilterChain
    implements DataChannelQueryFilterChain {
        private int idx;

        DataDomainQueryFilterChain() {
            this.idx = DataDomain.this.queryFilters.size();
        }

        @Override
        public QueryResponse onQuery(ObjectContext originatingContext, Query query) {
            return --this.idx >= 0 ? DataDomain.this.queryFilters.get(this.idx).onQuery(originatingContext, query, this) : DataDomain.this.onQueryNoFilters(originatingContext, query);
        }
    }

    final class DataDomainSyncFilterChain
    implements DataChannelSyncFilterChain {
        private int idx;

        DataDomainSyncFilterChain() {
            this.idx = DataDomain.this.syncFilters.size();
        }

        @Override
        public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
            return --this.idx >= 0 ? DataDomain.this.syncFilters.get(this.idx).onSync(originatingContext, changes, syncType, this) : DataDomain.this.onSyncNoFilters(originatingContext, changes, syncType);
        }
    }
}

