/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.internal.Debugger;
import org.apache.commons.jexl3.internal.introspection.IndexedType;
import org.apache.commons.jexl3.internal.introspection.Uberspect;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.apache.commons.jexl3.junit.Asserter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PropertyAccessTest
extends JexlTestCase {
    private Asserter asserter;

    public PropertyAccessTest() {
        super("PropertyAccessTest");
    }

    @Override
    @BeforeEach
    public void setUp() {
        this.asserter = new Asserter(this.JEXL);
    }

    @Test
    void test250() throws Exception {
        MapContext ctx = new MapContext();
        HashMap<Integer, String> x = new HashMap<Integer, String>();
        x.put(2, "123456789");
        ctx.set("x", x);
        JexlEngine engine = new JexlBuilder().uberspect((JexlUberspect)new Uberspect(null, null, JexlPermissions.UNRESTRICTED)).strict(true).silent(false).create();
        String stmt = "x.2.class.name";
        JexlScript script = engine.createScript(stmt);
        Object result = script.execute((JexlContext)ctx);
        Assertions.assertEquals((Object)"java.lang.String", (Object)result);
        stmt = "x.3?.class.name";
        script = engine.createScript(stmt);
        result = script.execute((JexlContext)ctx);
        Assertions.assertNull((Object)result);
        stmt = "x?.3.class.name";
        JexlScript script1 = engine.createScript(stmt);
        Assertions.assertThrows(JexlException.class, () -> script1.execute((JexlContext)ctx));
        stmt = "x?.3?.class.name";
        script = engine.createScript(stmt);
        result = script.execute((JexlContext)ctx);
        Assertions.assertNull((Object)result);
        stmt = "y?.3.class.name";
        script = engine.createScript(stmt);
        result = script.execute((JexlContext)ctx);
        Assertions.assertNull((Object)result);
        stmt = "x?.y?.z";
        script = engine.createScript(stmt);
        result = script.execute((JexlContext)ctx);
        Assertions.assertNull((Object)result);
        stmt = "x? (x.y? (x.y.z ?: null) :null) : null";
        script = engine.createScript(stmt);
        result = script.execute((JexlContext)ctx);
        Assertions.assertNull((Object)result);
    }

    @Test
    void test275a() throws Exception {
        JexlEngine jexl = new JexlBuilder().strict(true).safe(false).create();
        MapContext ctxt = new MapContext();
        Object result = null;
        Prompt p0 = new Prompt();
        p0.set("stuff", 42);
        ctxt.set("$in", (Object)p0);
        JexlScript script0 = jexl.createScript("$in[p].intValue()", new String[]{"p"});
        Assertions.assertThrows(JexlException.Property.class, () -> PropertyAccessTest.lambda$test275a$0(script0, (JexlContext)ctxt));
        Assertions.assertNull(result);
        result = script0.execute((JexlContext)ctxt, new Object[]{"stuff"});
        Assertions.assertEquals((Object)42, (Object)result);
        JexlScript script = jexl.createScript("$in[p]?.intValue()", new String[]{"p"});
        result = script.execute((JexlContext)ctxt, new Object[]{"fail"});
        Assertions.assertNull((Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{"stuff"});
        Assertions.assertEquals((Object)42, (Object)result);
        JexlScript script1 = jexl.createScript("$in.`${p}`.intValue()", new String[]{"p"});
        Assertions.assertThrows(JexlException.Property.class, () -> PropertyAccessTest.lambda$test275a$1(script1, (JexlContext)ctxt));
        result = script.execute((JexlContext)ctxt, new Object[]{"stuff"});
        Assertions.assertEquals((Object)42, (Object)result);
        script = jexl.createScript("$in.`${p}`?.intValue()", new String[]{"p"});
        result = script.execute((JexlContext)ctxt, new Object[]{"fail"});
        Assertions.assertNull((Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{"stuff"});
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    void test275b() throws Exception {
        JexlEngine jexl = new JexlBuilder().strict(true).safe(true).create();
        MapContext ctxt = new MapContext();
        Prompt p0 = new Prompt();
        p0.set("stuff", 42);
        ctxt.set("$in", (Object)p0);
        JexlScript script = jexl.createScript("$in[p].intValue()", new String[]{"p"});
        Object result = script.execute((JexlContext)ctxt, new Object[]{"fail"});
        Assertions.assertNull((Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{"stuff"});
        Assertions.assertEquals((Object)42, (Object)result);
        script = jexl.createScript("$in.`${p}`.intValue()", new String[]{"p"});
        result = script.execute((JexlContext)ctxt, new Object[]{"fail"});
        Assertions.assertNull((Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{"stuff"});
        Assertions.assertEquals((Object)42, (Object)result);
        script = jexl.createScript("$in.`${p}`?.intValue()", new String[]{"p"});
        result = script.execute((JexlContext)ctxt, new Object[]{"fail"});
        Assertions.assertNull((Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{"stuff"});
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    void testErroneousIdentifier() throws Exception {
        MapContext ctx = new MapContext();
        JexlEngine engine = new JexlBuilder().strict(true).silent(false).create();
        String stmt = "(x)->{ x?.class ?? 'oops' }";
        JexlScript script = engine.createScript(stmt);
        Object result = script.execute((JexlContext)ctx, new Object[]{"querty"});
        Assertions.assertEquals("querty".getClass(), (Object)result);
        stmt = "(x)->{ x.class1 ?? 'oops' }";
        script = engine.createScript(stmt);
        result = script.execute((JexlContext)ctx, new Object[]{"querty"});
        Assertions.assertEquals((Object)"oops", (Object)result);
        ctx.set("al", (Object)"la");
        stmt = "(x)->{ x.`c${al}ss` ?? 'oops' }";
        script = engine.createScript(stmt);
        result = script.execute((JexlContext)ctx, new Object[]{"querty"});
        Assertions.assertEquals("querty".getClass(), (Object)result);
        stmt = "(x)->{ x?.`c${al}ss` ?? 'oops' }";
        script = engine.createScript(stmt);
        result = script.execute((JexlContext)ctx, new Object[]{"querty"});
        Assertions.assertEquals("querty".getClass(), (Object)result);
        stmt = "(x)->{ x?.`c${la}ss` ?? 'oops' }";
        script = engine.createScript(stmt);
        result = script.execute((JexlContext)ctx, new Object[]{"querty"});
        Assertions.assertEquals((Object)"oops", (Object)result);
        stmt = "(x)->{ x.`c${la}ss` ?? 'oops' }";
        script = engine.createScript(stmt);
        result = script.execute((JexlContext)ctx, new Object[]{"querty"});
        Assertions.assertEquals((Object)"oops", (Object)result);
        stmt = "(x)->{ x?.`c${la--ss` ?? 'oops' }";
        try {
            script = engine.createScript(stmt);
            result = script.execute((JexlContext)ctx, new Object[]{"querty"});
        }
        catch (JexlException xany) {
            Assertions.assertNotNull((Object)xany.getMessage());
            Assertions.assertTrue((boolean)xany.getMessage().contains("c${la--ss"));
        }
        stmt = "(x)->{ x.`c${la--ss` ?? 'oops' }";
        try {
            script = engine.createScript(stmt);
            result = script.execute((JexlContext)ctx, new Object[]{"querty"});
        }
        catch (JexlException xany) {
            Assertions.assertNotNull((Object)xany.getMessage());
            Assertions.assertTrue((boolean)xany.getMessage().contains("c${la--ss"));
        }
    }

    @Test
    void testInnerProperty() throws Exception {
        PropertyArithmetic pa = new PropertyArithmetic(true);
        JexlEngine jexl = new JexlBuilder().arithmetic((JexlArithmetic)pa).debug(true).strict(true).cache(32).create();
        Container quux = new Container("quux", 42);
        int calls = pa.getCalls();
        JexlScript getName = this.JEXL.createScript("foo.property.name", new String[]{"foo"});
        Object result = getName.execute(null, new Object[]{quux});
        Assertions.assertEquals((Object)"quux", (Object)result);
        JexlScript get0 = this.JEXL.createScript("foo.property.0", new String[]{"foo"});
        result = get0.execute(null, new Object[]{quux});
        Assertions.assertEquals((Object)"quux", (Object)result);
        JexlScript getNumber = this.JEXL.createScript("foo.property.number", new String[]{"foo"});
        result = getNumber.execute(null, new Object[]{quux});
        Assertions.assertEquals((Object)42, (Object)result);
        JexlScript get1 = this.JEXL.createScript("foo.property.1", new String[]{"foo"});
        result = get1.execute(null, new Object[]{quux});
        Assertions.assertEquals((Object)42, (Object)result);
        JexlScript setName = this.JEXL.createScript("foo.property.name = $0", new String[]{"foo", "$0"});
        setName.execute(null, new Object[]{quux, "QUUX"});
        result = getName.execute(null, new Object[]{quux});
        Assertions.assertEquals((Object)"QUUX", (Object)result);
        result = get0.execute(null, new Object[]{quux});
        Assertions.assertEquals((Object)"QUUX", (Object)result);
        JexlScript set0 = this.JEXL.createScript("foo.property.0 = $0", new String[]{"foo", "$0"});
        set0.execute(null, new Object[]{quux, "BAR"});
        result = getName.execute(null, new Object[]{quux});
        Assertions.assertEquals((Object)"BAR", (Object)result);
        result = get0.execute(null, new Object[]{quux});
        Assertions.assertEquals((Object)"BAR", (Object)result);
        JexlScript setNumber = this.JEXL.createScript("foo.property.number = $0", new String[]{"foo", "$0"});
        setNumber.execute(null, new Object[]{quux, -42});
        result = getNumber.execute(null, new Object[]{quux});
        Assertions.assertEquals((Object)-42, (Object)result);
        result = get1.execute(null, new Object[]{quux});
        Assertions.assertEquals((Object)-42, (Object)result);
        JexlScript set1 = this.JEXL.createScript("foo.property.1 = $0", new String[]{"foo", "$0"});
        set1.execute(null, new Object[]{quux, 24});
        result = getNumber.execute(null, new Object[]{quux});
        Assertions.assertEquals((Object)24, (Object)result);
        result = get1.execute(null, new Object[]{quux});
        Assertions.assertEquals((Object)24, (Object)result);
        Assertions.assertEquals((int)calls, (int)pa.getCalls());
    }

    @Test
    void testInnerViaArithmetic() throws Exception {
        PropertyArithmetic pa = new PropertyArithmetic(true);
        JexlEngine jexl = new JexlBuilder().arithmetic((JexlArithmetic)pa).debug(true).strict(true).cache(32).create();
        PropertyContainer quux = new PropertyContainer("bar", 169);
        JexlScript getName = jexl.createScript("foo.property.name", new String[]{"foo"});
        Object result = getName.execute(null, new Object[]{quux});
        Assertions.assertEquals((Object)"bar", (Object)result);
        int calls = pa.getCalls();
        JexlScript setName = jexl.createScript("foo.property.name = $0", new String[]{"foo", "$0"});
        setName.execute(null, new Object[]{quux, 123});
        result = getName.execute(null, new Object[]{quux});
        Assertions.assertEquals((Object)"123", (Object)result);
        setName.execute(null, new Object[]{quux, 456});
        result = getName.execute(null, new Object[]{quux});
        Assertions.assertEquals((Object)"456", (Object)result);
        Assertions.assertEquals((int)(calls + 2), (int)pa.getCalls());
        setName.execute(null, new Object[]{quux, "quux"});
        result = getName.execute(null, new Object[]{quux});
        Assertions.assertEquals((Object)"QUUX", (Object)result);
        Assertions.assertEquals((int)(calls + 2), (int)pa.getCalls());
        JexlScript getNumber = jexl.createScript("foo.property.number", new String[]{"foo"});
        result = getNumber.execute(null, new Object[]{quux});
        Assertions.assertEquals((Object)169, (Object)result);
        JexlScript setNumber = jexl.createScript("foo.property.number = $0", new String[]{"foo", "$0"});
        setNumber.execute(null, new Object[]{quux, 42});
        result = getNumber.execute(null, new Object[]{quux});
        Assertions.assertEquals((Object)1042, (Object)result);
        setNumber.execute(null, new Object[]{quux, 24});
        result = getNumber.execute(null, new Object[]{quux});
        Assertions.assertEquals((Object)1024, (Object)result);
        Assertions.assertEquals((int)(calls + 4), (int)pa.getCalls());
        setNumber.execute(null, new Object[]{quux, "42"});
        result = getNumber.execute(null, new Object[]{quux});
        Assertions.assertEquals((Object)1042, (Object)result);
        Assertions.assertEquals((int)(calls + 4), (int)pa.getCalls());
    }

    @Test
    void testPropertyProperty() throws Exception {
        Object[] foo;
        Integer i42 = 42;
        Integer i43 = 43;
        String s42 = "fourty-two";
        foo[0] = foo = new Object[3];
        foo[1] = i42;
        foo[2] = "fourty-two";
        this.asserter.setVariable("foo", foo);
        this.asserter.setVariable("zero", 0);
        this.asserter.setVariable("one", 1);
        this.asserter.setVariable("two", 2);
        for (int l = 0; l < 2; ++l) {
            this.asserter.assertExpression("foo.0", foo, new Object[0]);
            this.asserter.assertExpression("foo.0.'0'", foo, new Object[0]);
            this.asserter.assertExpression("foo.'1'", foo[1], new Object[0]);
            this.asserter.assertExpression("foo.0.'1'", foo[1], new Object[0]);
            this.asserter.assertExpression("foo.0.'1' = 43", i43, new Object[0]);
            this.asserter.assertExpression("foo.0.'1'", i43, new Object[0]);
            this.asserter.assertExpression("foo.0.'1' = 42", i42, new Object[0]);
            this.asserter.assertExpression("foo?.0.'1'", i42, new Object[0]);
            this.asserter.assertExpression("foo?.0", foo, new Object[0]);
            this.asserter.assertExpression("foo?.0.'0'", foo, new Object[0]);
            this.asserter.assertExpression("foo?.'1'", foo[1], new Object[0]);
            this.asserter.assertExpression("foo.0?.'1'", foo[1], new Object[0]);
            this.asserter.assertExpression("foo?.0.'1' = 43", i43, new Object[0]);
            this.asserter.assertExpression("foo?.0?.'1'", i43, new Object[0]);
            this.asserter.assertExpression("foo?.0.'1' = 42", i42, new Object[0]);
            this.asserter.assertExpression("foo?.0.'1'", i42, new Object[0]);
            this.asserter.assertExpression("foo?.0.`1`", i42, new Object[0]);
            this.asserter.assertExpression("foo?.0", foo, new Object[0]);
            this.asserter.assertExpression("foo?.0.'0'", foo, new Object[0]);
            this.asserter.assertExpression("foo?.`1`", foo[1], new Object[0]);
            this.asserter.assertExpression("foo?.0.`1`", foo[1], new Object[0]);
            this.asserter.assertExpression("foo?.0.`${one}` = 43", i43, new Object[0]);
            this.asserter.assertExpression("foo.0?.`${one}`", i43, new Object[0]);
            this.asserter.assertExpression("foo.0.`${one}` = 42", i42, new Object[0]);
            this.asserter.assertExpression("foo?.0?.`${one}`", i42, new Object[0]);
            this.asserter.assertExpression("foo?[0].'1'", i42, new Object[0]);
            this.asserter.assertExpression("foo?[0]", foo, new Object[0]);
            this.asserter.assertExpression("foo?[0].'0'", foo, new Object[0]);
            this.asserter.assertExpression("foo?[1]", foo[1], new Object[0]);
            this.asserter.assertExpression("foo[0]?.'1'", foo[1], new Object[0]);
            this.asserter.assertExpression("foo?[0].'1' = 43", i43, new Object[0]);
            this.asserter.assertExpression("foo?[0]?.'1'", i43, new Object[0]);
            this.asserter.assertExpression("foo?[0].'1' = 42", i42, new Object[0]);
            this.asserter.assertExpression("foo?[0].'1'", i42, new Object[0]);
        }
    }

    @Test
    void testStringIdentifier() throws Exception {
        HashMap<String, String> foo = new HashMap<String, String>();
        MapContext jc = new MapContext();
        jc.set("foo", foo);
        foo.put("q u u x", "456");
        JexlExpression e = this.JEXL.createExpression("foo.\"q u u x\"");
        Object result = e.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)"456", (Object)result);
        e = this.JEXL.createExpression("foo.'q u u x'");
        result = e.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)"456", (Object)result);
        JexlScript s = this.JEXL.createScript("foo.\"q u u x\"");
        result = s.execute((JexlContext)jc);
        Assertions.assertEquals((Object)"456", (Object)result);
        s = this.JEXL.createScript("foo.'q u u x'");
        result = s.execute((JexlContext)jc);
        Assertions.assertEquals((Object)"456", (Object)result);
        Debugger dbg = new Debugger();
        dbg.debug(e);
        String dbgdata = dbg.toString();
        Assertions.assertEquals((Object)"foo.'q u u x'", (Object)dbgdata);
    }

    private static /* synthetic */ void lambda$test275a$1(JexlScript script1, JexlContext ctxt) throws Throwable {
        script1.execute(ctxt, new Object[]{"fail"});
    }

    private static /* synthetic */ void lambda$test275a$0(JexlScript script0, JexlContext ctxt) throws Throwable {
        script0.execute(ctxt, new Object[]{"fail"});
    }

    public static class Prompt {
        private final Map<String, PromptValue> values = new HashMap<String, PromptValue>();

        public Object get(String name) {
            PromptValue v = this.values.get(name);
            return v != null ? v.getValue() : null;
        }

        public void set(String name, Object value) {
            this.values.put(name, new PromptValue(value));
        }
    }

    public static class PropertyArithmetic
    extends JexlArithmetic {
        int ncalls;

        public PropertyArithmetic(boolean astrict) {
            super(astrict);
        }

        public int getCalls() {
            return this.ncalls;
        }

        public Object propertySet(IndexedType.IndexedContainer map, String key, Integer value) {
            if (map.getContainerClass().equals(PropertyContainer.class) && map.getContainerName().equals("property")) {
                try {
                    map.set((Object)key, (Object)value.toString());
                    ++this.ncalls;
                }
                catch (Exception xany) {
                    throw new JexlException.Operator(null, key + "." + value.toString(), (Throwable)xany);
                }
                return null;
            }
            return JexlEngine.TRY_FAILED;
        }
    }

    public static class Container
    extends PropertyContainer {
        public Container(String name, int number) {
            super(name, number);
        }

        public Object getProperty(int ref) {
            switch (ref) {
                case 0: {
                    return this.value0;
                }
                case 1: {
                    return this.value1;
                }
            }
            return null;
        }

        public void setProperty(int ref, int value) {
            if (1 == ref) {
                this.value1 = value;
            }
        }

        public void setProperty(int ref, String value) {
            if (0 == ref) {
                this.value0 = value;
            }
        }

        public void setProperty(String name, int value) {
            if ("number".equals(name)) {
                this.value1 = value;
            }
        }

        @Override
        public void setProperty(String name, String value) {
            if ("name".equals(name)) {
                this.value0 = value;
            }
        }
    }

    public static class PropertyContainer {
        String value0;
        int value1;

        public PropertyContainer(String name, int number) {
            this.value0 = name;
            this.value1 = number;
        }

        public Object getProperty(String name) {
            if ("name".equals(name)) {
                return this.value0;
            }
            if ("number".equals(name)) {
                return this.value1;
            }
            return null;
        }

        public void setProperty(String name, String value) {
            if ("name".equals(name)) {
                this.value0 = value.toUpperCase();
            }
            if ("number".equals(name)) {
                this.value1 = Integer.parseInt(value) + 1000;
            }
        }
    }

    public static class PromptValue {
        private Object value;

        public PromptValue(Object v) {
            this.value = v;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

