/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.jexl3.Foo;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ForEachTest
extends JexlTestCase {
    public ForEachTest() {
        super("ForEachTest");
    }

    @Test
    void testForEachBreakBroken() throws Exception {
        JexlException.Parsing xparse = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> this.JEXL.createScript("if (true) { break; }"), (String)"break is out of loop!");
        Assertions.assertTrue((boolean)xparse.detailedMessage().contains("break"));
    }

    @Test
    void testForEachBreakMethod() throws Exception {
        JexlScript e = this.JEXL.createScript("var rr = -1; for (var item : [1, 2, 3 ,4 ,5, 6]) { if (item == 3) { rr = item; break; }} rr");
        MapContext jc = new MapContext();
        jc.set("list", (Object)new Foo());
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)3, (Object)o, (String)"Result is not last evaluated expression");
    }

    @Test
    void testForEachContinueBroken() throws Exception {
        JexlException.Parsing xparse = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> this.JEXL.createScript("var rr = 0; continue;"), (String)"continue is out of loop!");
        Assertions.assertTrue((boolean)xparse.detailedMessage().contains("continue"));
    }

    @Test
    void testForEachContinueMethod() throws Exception {
        JexlScript e = this.JEXL.createScript("var rr = 0; for (var item : [1, 2, 3 ,4 ,5, 6]) { if (item <= 3) continue; rr = rr + item;}");
        MapContext jc = new MapContext();
        jc.set("list", (Object)new Foo());
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)15, (Object)o, (String)"Result is not last evaluated expression");
    }

    @Test
    void testForEachWithArray() throws Exception {
        JexlScript e = this.JEXL.createScript("for (item : list) item");
        MapContext jc = new MapContext();
        jc.set("list", (Object)new Object[]{"Hello", "World"});
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)"World", (Object)o, (String)"Result is not last evaluated expression");
    }

    @Test
    void testForEachWithBlock() throws Exception {
        JexlScript exs0 = this.JEXL.createScript("for (var in : list) { x = x + in; }");
        MapContext jc = new MapContext();
        jc.set("list", (Object)new Object[]{2, 3});
        jc.set("x", (Object)1);
        Object o = exs0.execute((JexlContext)jc);
        Assertions.assertEquals((Object)6, (Object)o, (String)"Result is wrong");
        Assertions.assertEquals((Object)6, (Object)jc.get("x"), (String)"x is wrong");
    }

    @Test
    void testForEachWithCollection() throws Exception {
        JexlScript e = this.JEXL.createScript("for (var item : list) item");
        MapContext jc = new MapContext();
        jc.set("list", Arrays.asList("Hello", "World"));
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)"World", (Object)o, (String)"Result is not last evaluated expression");
    }

    @Test
    void testForEachWithEmptyList() throws Exception {
        JexlScript e = this.JEXL.createScript("for (item : list) 1+1");
        MapContext jc = new MapContext();
        jc.set("list", Collections.emptyList());
        Object o = e.execute((JexlContext)jc);
        Assertions.assertNull((Object)o);
    }

    @Test
    void testForEachWithEmptyStatement() throws Exception {
        JexlScript e = this.JEXL.createScript("for (item : list) ;");
        MapContext jc = new MapContext();
        jc.set("list", Collections.emptyList());
        Object o = e.execute((JexlContext)jc);
        Assertions.assertNull((Object)o);
    }

    @Test
    void testForEachWithEnumeration() throws Exception {
        JexlScript e = this.JEXL.createScript("for (var item : list) item");
        MapContext jc = new MapContext();
        jc.set("list", (Object)new StringTokenizer("Hello,World", ","));
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)"World", (Object)o, (String)"Result is not last evaluated expression");
    }

    @Test
    void testForEachWithIterator() throws Exception {
        JexlScript e = this.JEXL.createScript("for (var item : list) item");
        MapContext jc = new MapContext();
        jc.set("list", Arrays.asList("Hello", "World").iterator());
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)"World", (Object)o, (String)"Result is not last evaluated expression");
    }

    @Test
    void testForEachWithIteratorMethod() throws Exception {
        JexlScript e = this.JEXL.createScript("for (var item : list.cheezy) item");
        MapContext jc = new MapContext();
        jc.set("list", (Object)new Foo());
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)"brie", (Object)o, (String)"Result is not last evaluated expression");
    }

    @Test
    void testForEachWithListExpression() throws Exception {
        JexlScript e = this.JEXL.createScript("for (var item : list.keySet()) item");
        MapContext jc = new MapContext();
        Properties map = System.getProperties();
        String lastKey = (String)new ArrayList(map.keySet()).get(System.getProperties().size() - 1);
        jc.set("list", (Object)map);
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)lastKey, (Object)o, (String)"Result is not last evaluated expression");
    }

    @Test
    void testForEachWithMap() throws Exception {
        JexlScript e = this.JEXL.createScript("for(item : list) item");
        MapContext jc = new MapContext();
        Properties map = System.getProperties();
        String lastProperty = (String)new ArrayList(map.values()).get(System.getProperties().size() - 1);
        jc.set("list", (Object)map);
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)lastProperty, (Object)o, (String)"Result is not last evaluated expression");
    }

    @Test
    void testForEachWithProperty() throws Exception {
        JexlScript e = this.JEXL.createScript("for(var item : list.cheeseList) item");
        MapContext jc = new MapContext();
        jc.set("list", (Object)new Foo());
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)"brie", (Object)o, (String)"Result is not last evaluated expression");
    }

    @Test
    void testForLoop0a() {
        String src = "(l)->{ for (let x = 0; x < 4; ++x) { l.add(x); } }";
        JexlEngine jexl = new JexlBuilder().safe(false).create();
        JexlScript script = jexl.createScript("(l)->{ for (let x = 0; x < 4; ++x) { l.add(x); } }");
        ArrayList l = new ArrayList();
        Object result = script.execute(null, new Object[]{l});
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals(Arrays.asList(0, 1, 2, 3), l);
        String resrc = ForEachTest.toString(script);
        Assertions.assertEquals((Object)"(l)->{ for (let x = 0; x < 4; ++x) { l.add(x); } }", (Object)resrc);
    }

    @Test
    void testForLoop0b0() {
        String src = "(l)->{ for (let x = 0, y = 0; x < 4; ++x) l.add(x) }";
        JexlEngine jexl = new JexlBuilder().safe(false).create();
        JexlScript script = jexl.createScript("(l)->{ for (let x = 0, y = 0; x < 4; ++x) l.add(x) }");
        ArrayList l = new ArrayList();
        Object result = script.execute(null, new Object[]{l});
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals(Arrays.asList(0, 1, 2, 3), l);
        String resrc = ForEachTest.toString(script);
        Assertions.assertEquals((Object)"(l)->{ for (let x = 0, y = 0; x < 4; ++x) l.add(x) }", (Object)resrc);
    }
}

