/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.service.extensions.xa.recovery;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.api.config.ServerLocatorConfig;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManagerFactory;

public class XARecoveryConfig {
    public static final String JNDI_NAME_PROPERTY_KEY = "JNDI_NAME";
    private final boolean ha;
    private final TransportConfiguration[] transportConfiguration;
    private final DiscoveryGroupConfiguration discoveryConfiguration;
    private final String username;
    private final String password;
    private final Map<String, String> properties;
    private final ClientProtocolManagerFactory clientProtocolManager;
    private ServerLocatorConfig locatorConfig;

    public static XARecoveryConfig newConfig(ActiveMQConnectionFactory factory, String userName, String password, Map<String, String> properties) {
        return new XARecoveryConfig(factory.getServerLocator(), userName, password, properties);
    }

    public XARecoveryConfig(boolean ha, TransportConfiguration[] transportConfiguration, String username, String password, Map<String, String> properties, ClientProtocolManagerFactory clientProtocolManager) {
        this(ha, transportConfiguration, username, password, properties, clientProtocolManager, null);
    }

    public XARecoveryConfig(boolean ha, TransportConfiguration[] transportConfiguration, String username, String password, Map<String, String> properties, ClientProtocolManagerFactory clientProtocolManager, ServerLocatorConfig locatorConfig) {
        TransportConfiguration[] newTransportConfiguration = new TransportConfiguration[transportConfiguration.length];
        for (int i = 0; i < transportConfiguration.length; ++i) {
            newTransportConfiguration[i] = clientProtocolManager != null ? clientProtocolManager.adaptTransportConfiguration(transportConfiguration[i].newTransportConfig("")) : transportConfiguration[i].newTransportConfig("");
        }
        this.transportConfiguration = newTransportConfiguration;
        this.discoveryConfiguration = null;
        this.username = username;
        this.password = password;
        this.ha = ha;
        this.properties = Objects.requireNonNullElseGet(properties, () -> new HashMap());
        this.clientProtocolManager = clientProtocolManager;
        this.locatorConfig = locatorConfig;
    }

    public XARecoveryConfig(boolean ha, TransportConfiguration[] transportConfiguration, String username, String password, Map<String, String> properties) {
        this(ha, transportConfiguration, username, password, properties, null);
    }

    public XARecoveryConfig(boolean ha, DiscoveryGroupConfiguration discoveryConfiguration, String username, String password, Map<String, String> properties, ClientProtocolManagerFactory clientProtocolManager) {
        this.discoveryConfiguration = discoveryConfiguration;
        this.transportConfiguration = null;
        this.username = username;
        this.password = password;
        this.ha = ha;
        this.clientProtocolManager = clientProtocolManager;
        this.properties = properties == null ? Collections.unmodifiableMap(new HashMap()) : Collections.unmodifiableMap(properties);
    }

    public XARecoveryConfig(boolean ha, DiscoveryGroupConfiguration discoveryConfiguration, String username, String password, Map<String, String> properties) {
        this(ha, discoveryConfiguration, username, password, properties, null);
    }

    private XARecoveryConfig(ServerLocator serverLocator, String username, String password, Map<String, String> properties) {
        ClientProtocolManagerFactory clientProtocolManager = serverLocator.getProtocolManagerFactory();
        if (serverLocator.getDiscoveryGroupConfiguration() != null) {
            this.discoveryConfiguration = serverLocator.getDiscoveryGroupConfiguration();
            this.transportConfiguration = null;
        } else {
            TransportConfiguration[] transportConfiguration = serverLocator.getStaticTransportConfigurations();
            TransportConfiguration[] newTransportConfiguration = new TransportConfiguration[transportConfiguration.length];
            for (int i = 0; i < transportConfiguration.length; ++i) {
                newTransportConfiguration[i] = clientProtocolManager != null ? clientProtocolManager.adaptTransportConfiguration(transportConfiguration[i].newTransportConfig("")) : transportConfiguration[i].newTransportConfig("");
            }
            this.transportConfiguration = newTransportConfiguration;
            this.discoveryConfiguration = null;
        }
        this.username = username;
        this.password = password;
        this.ha = serverLocator.isHA();
        this.properties = properties == null ? Collections.unmodifiableMap(new HashMap()) : Collections.unmodifiableMap(properties);
        this.clientProtocolManager = clientProtocolManager;
        this.locatorConfig = serverLocator.getLocatorConfig();
    }

    public boolean isHA() {
        return this.ha;
    }

    public DiscoveryGroupConfiguration getDiscoveryConfiguration() {
        return this.discoveryConfiguration;
    }

    public TransportConfiguration[] getTransportConfig() {
        return this.transportConfiguration;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public ClientProtocolManagerFactory getClientProtocolManager() {
        return this.clientProtocolManager;
    }

    public ServerLocator createServerLocator() {
        ServerLocator serverLocator = this.getDiscoveryConfiguration() != null ? ActiveMQClient.createServerLocator((boolean)this.isHA(), (DiscoveryGroupConfiguration)this.getDiscoveryConfiguration()).setProtocolManagerFactory(this.clientProtocolManager) : ActiveMQClient.createServerLocator((boolean)this.isHA(), (TransportConfiguration[])this.getTransportConfig()).setProtocolManagerFactory(this.clientProtocolManager);
        if (this.locatorConfig != null) {
            serverLocator.setLocatorConfig(new ServerLocatorConfig(this.locatorConfig));
        }
        return serverLocator;
    }

    public ServerLocatorConfig getLocatorConfig() {
        return this.locatorConfig;
    }

    public int hashCode() {
        return Objects.hash(this.discoveryConfiguration, Arrays.hashCode(this.transportConfiguration));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof XARecoveryConfig)) {
            return false;
        }
        XARecoveryConfig other = (XARecoveryConfig)obj;
        return Objects.equals(this.discoveryConfiguration, other.discoveryConfiguration) && Arrays.equals(this.transportConfiguration, other.transportConfiguration);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("XARecoveryConfig [transportConfiguration=" + Arrays.toString(this.transportConfiguration));
        builder.append(", discoveryConfiguration=" + String.valueOf(this.discoveryConfiguration));
        builder.append(", username=" + this.username);
        builder.append(", password=****");
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            builder.append(", " + entry.getKey() + "=" + entry.getValue());
        }
        builder.append("]");
        return builder.toString();
    }
}

