/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import org.apache.cxf.tools.wsdlto.core.DefaultValueProvider;

public class RandomValueProvider
implements DefaultValueProvider {
    Random random = new Random();

    @Override
    public boolean getBooleanValue(String path) {
        return this.random.nextBoolean();
    }

    @Override
    public byte getByteValue(String path) {
        return (byte)this.random.nextInt();
    }

    @Override
    public char getCharValue(String path) {
        return (char)this.random.nextInt();
    }

    @Override
    public double getDoubleValue(String path) {
        return this.random.nextDouble();
    }

    @Override
    public float getFloatValue(String path) {
        return this.random.nextFloat();
    }

    @Override
    public int getIntValue(String path) {
        return this.random.nextInt();
    }

    @Override
    public long getLongValue(String path) {
        return this.random.nextLong();
    }

    @Override
    public short getShortValue(String path) {
        return (short)this.random.nextInt();
    }

    @Override
    public String getStringValue(String path) {
        return path.substring(path.lastIndexOf(47) + 1) + this.getIntValue(path);
    }

    @Override
    public QName getQNameValue(String path) {
        return new QName("http://" + this.getStringValue(path) + ".com", this.getStringValue(path));
    }

    @Override
    public URI getURIValue(String path) {
        try {
            return new URI("http://" + this.getStringValue(path) + ".com/" + path);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    @Override
    public BigDecimal getBigDecimalValue(String path) {
        Object s = Long.toString(this.random.nextLong());
        s = (String)s + ".";
        long nextLong = this.random.nextLong();
        if (nextLong == Long.MIN_VALUE) {
            ++nextLong;
        }
        s = (String)s + Long.toString(Math.abs(nextLong));
        return new BigDecimal((String)s);
    }

    @Override
    public BigInteger getBigIntegerValue(String path) {
        Object s = Long.toString(this.random.nextLong());
        long nextLong = this.random.nextLong();
        if (nextLong == Long.MIN_VALUE) {
            ++nextLong;
        }
        s = (String)s + Long.toString(Math.abs(nextLong));
        return new BigInteger((String)s);
    }

    @Override
    public String getXMLGregorianCalendarValueString(String path) {
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar()).toXMLFormat();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            return null;
        }
    }

    @Override
    public String getDurationValueString(String path) {
        try {
            return DatatypeFactory.newInstance().newDuration(this.random.nextLong()).toString();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            return "P1Y35DT60M60.500S";
        }
    }

    @Override
    public String chooseEnumValue(String path, Set<String> values) {
        int i = this.random.nextInt(values.size());
        for (String s : values) {
            if (i == 0) {
                return s;
            }
            --i;
        }
        return values.iterator().next();
    }

    @Override
    public int getListLength(String path) {
        int cnt = path.split("/").length;
        return cnt > 5 ? 0 : 1;
    }
}

