/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.model;

import lombok.Generated;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependResult;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependentType;

public class DependentItem {
    private DependentType dependentType;
    private long projectCode;
    private long definitionCode;
    private long depTaskCode;
    private String cycle;
    private String dateValue;
    private DependResult dependResult;
    private Boolean parameterPassing = false;

    public String getKey() {
        return String.format("%d-%d-%s-%s", this.getDefinitionCode(), this.getDepTaskCode(), this.getCycle(), this.getDateValue());
    }

    public DependentItem fromKey(String key) {
        String[] parts = key.split("-");
        if (parts.length != 4) {
            throw new IllegalArgumentException("Invalid key format");
        }
        this.setDefinitionCode(Long.parseLong(parts[0]));
        this.setDepTaskCode(Long.parseLong(parts[1]));
        this.setCycle(parts[2]);
        this.setDateValue(parts[3]);
        return this;
    }

    @Generated
    public DependentItem() {
    }

    @Generated
    public DependentType getDependentType() {
        return this.dependentType;
    }

    @Generated
    public long getProjectCode() {
        return this.projectCode;
    }

    @Generated
    public long getDefinitionCode() {
        return this.definitionCode;
    }

    @Generated
    public long getDepTaskCode() {
        return this.depTaskCode;
    }

    @Generated
    public String getCycle() {
        return this.cycle;
    }

    @Generated
    public String getDateValue() {
        return this.dateValue;
    }

    @Generated
    public DependResult getDependResult() {
        return this.dependResult;
    }

    @Generated
    public Boolean getParameterPassing() {
        return this.parameterPassing;
    }

    @Generated
    public void setDependentType(DependentType dependentType) {
        this.dependentType = dependentType;
    }

    @Generated
    public void setProjectCode(long projectCode) {
        this.projectCode = projectCode;
    }

    @Generated
    public void setDefinitionCode(long definitionCode) {
        this.definitionCode = definitionCode;
    }

    @Generated
    public void setDepTaskCode(long depTaskCode) {
        this.depTaskCode = depTaskCode;
    }

    @Generated
    public void setCycle(String cycle) {
        this.cycle = cycle;
    }

    @Generated
    public void setDateValue(String dateValue) {
        this.dateValue = dateValue;
    }

    @Generated
    public void setDependResult(DependResult dependResult) {
        this.dependResult = dependResult;
    }

    @Generated
    public void setParameterPassing(Boolean parameterPassing) {
        this.parameterPassing = parameterPassing;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependentItem)) {
            return false;
        }
        DependentItem other = (DependentItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProjectCode() != other.getProjectCode()) {
            return false;
        }
        if (this.getDefinitionCode() != other.getDefinitionCode()) {
            return false;
        }
        if (this.getDepTaskCode() != other.getDepTaskCode()) {
            return false;
        }
        Boolean this$parameterPassing = this.getParameterPassing();
        Boolean other$parameterPassing = other.getParameterPassing();
        if (this$parameterPassing == null ? other$parameterPassing != null : !((Object)this$parameterPassing).equals(other$parameterPassing)) {
            return false;
        }
        DependentType this$dependentType = this.getDependentType();
        DependentType other$dependentType = other.getDependentType();
        if (this$dependentType == null ? other$dependentType != null : !((Object)((Object)this$dependentType)).equals((Object)other$dependentType)) {
            return false;
        }
        String this$cycle = this.getCycle();
        String other$cycle = other.getCycle();
        if (this$cycle == null ? other$cycle != null : !this$cycle.equals(other$cycle)) {
            return false;
        }
        String this$dateValue = this.getDateValue();
        String other$dateValue = other.getDateValue();
        if (this$dateValue == null ? other$dateValue != null : !this$dateValue.equals(other$dateValue)) {
            return false;
        }
        DependResult this$dependResult = this.getDependResult();
        DependResult other$dependResult = other.getDependResult();
        return !(this$dependResult == null ? other$dependResult != null : !((Object)((Object)this$dependResult)).equals((Object)other$dependResult));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DependentItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $projectCode = this.getProjectCode();
        result = result * 59 + (int)($projectCode >>> 32 ^ $projectCode);
        long $definitionCode = this.getDefinitionCode();
        result = result * 59 + (int)($definitionCode >>> 32 ^ $definitionCode);
        long $depTaskCode = this.getDepTaskCode();
        result = result * 59 + (int)($depTaskCode >>> 32 ^ $depTaskCode);
        Boolean $parameterPassing = this.getParameterPassing();
        result = result * 59 + ($parameterPassing == null ? 43 : ((Object)$parameterPassing).hashCode());
        DependentType $dependentType = this.getDependentType();
        result = result * 59 + ($dependentType == null ? 43 : ((Object)((Object)$dependentType)).hashCode());
        String $cycle = this.getCycle();
        result = result * 59 + ($cycle == null ? 43 : $cycle.hashCode());
        String $dateValue = this.getDateValue();
        result = result * 59 + ($dateValue == null ? 43 : $dateValue.hashCode());
        DependResult $dependResult = this.getDependResult();
        result = result * 59 + ($dependResult == null ? 43 : ((Object)((Object)$dependResult)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DependentItem(dependentType=" + (Object)((Object)this.getDependentType()) + ", projectCode=" + this.getProjectCode() + ", definitionCode=" + this.getDefinitionCode() + ", depTaskCode=" + this.getDepTaskCode() + ", cycle=" + this.getCycle() + ", dateValue=" + this.getDateValue() + ", dependResult=" + (Object)((Object)this.getDependResult()) + ", parameterPassing=" + this.getParameterPassing() + ")";
    }
}

