/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client;

import io.kubernetes.client.custom.NodeMetrics;
import io.kubernetes.client.custom.NodeMetricsList;
import io.kubernetes.client.custom.PodMetrics;
import io.kubernetes.client.custom.PodMetricsList;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.util.generic.GenericKubernetesApi;

public class Metrics {
    private ApiClient apiClient;

    public Metrics() {
        this(Configuration.getDefaultApiClient());
    }

    public Metrics(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public NodeMetricsList getNodeMetrics() throws ApiException {
        GenericKubernetesApi<NodeMetrics, NodeMetricsList> metricsClient = new GenericKubernetesApi<NodeMetrics, NodeMetricsList>(NodeMetrics.class, NodeMetricsList.class, "metrics.k8s.io", "v1beta1", "nodes", this.apiClient);
        return metricsClient.list().getObject();
    }

    public PodMetricsList getPodMetrics(String namespace) throws ApiException {
        GenericKubernetesApi<PodMetrics, PodMetricsList> metricsClient = new GenericKubernetesApi<PodMetrics, PodMetricsList>(PodMetrics.class, PodMetricsList.class, "metrics.k8s.io", "v1beta1", "pods", this.apiClient);
        return metricsClient.list(namespace).getObject();
    }
}

