/*
 * Decompiled with CFR 0.152.
 */
package shade.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import shade.fasterxml.jackson.core.JsonParser;
import shade.fasterxml.jackson.databind.DeserializationContext;
import shade.fasterxml.jackson.databind.JsonMappingException;
import shade.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import shade.fasterxml.jackson.databind.type.LogicalType;

public class AtomicIntegerDeserializer
extends StdScalarDeserializer<AtomicInteger> {
    private static final long serialVersionUID = 1L;

    public AtomicIntegerDeserializer() {
        super(AtomicInteger.class);
    }

    @Override
    public AtomicInteger deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.isExpectedNumberIntToken()) {
            return new AtomicInteger(p.getIntValue());
        }
        Integer I = this._parseInteger(p, ctxt, AtomicInteger.class);
        return I == null ? null : new AtomicInteger(I);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Integer;
    }

    @Override
    public Object getEmptyValue(DeserializationContext ctxt) throws JsonMappingException {
        return new AtomicInteger();
    }
}

