/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.scheduler.quartz;

import org.apache.dolphinscheduler.scheduler.quartz.ProcessScheduleTask;
import org.apache.dolphinscheduler.scheduler.quartz.QuartzJobData;
import org.apache.dolphinscheduler.scheduler.quartz.QuartzJobKey;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;

public class QuartzJobDetailBuilder {
    private Integer projectId;
    private Integer scheduleId;

    public static QuartzJobDetailBuilder newBuilder() {
        return new QuartzJobDetailBuilder();
    }

    public QuartzJobDetailBuilder withProjectId(Integer projectId) {
        this.projectId = projectId;
        return this;
    }

    public QuartzJobDetailBuilder withSchedule(Integer scheduleId) {
        this.scheduleId = scheduleId;
        return this;
    }

    public JobDetail build() {
        if (this.projectId == null) {
            throw new IllegalArgumentException("projectId cannot be null");
        }
        if (this.scheduleId == null) {
            throw new IllegalArgumentException("scheduleId cannot be null");
        }
        QuartzJobData quartzJobData = QuartzJobData.of(this.projectId, this.scheduleId);
        return JobBuilder.newJob(ProcessScheduleTask.class).withIdentity(QuartzJobKey.of(this.projectId, this.scheduleId).toJobKey()).setJobData(quartzJobData.toJobDataMap()).build();
    }
}

