/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.DocumentDbCollectionDatasetTypeProperties;
import com.azure.resourcemanager.datafactory.models.Dataset;
import com.azure.resourcemanager.datafactory.models.DatasetFolder;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="DocumentDbCollection")
public final class DocumentDbCollectionDataset
extends Dataset {
    @JsonProperty(value="typeProperties", required=true)
    private DocumentDbCollectionDatasetTypeProperties innerTypeProperties = new DocumentDbCollectionDatasetTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(DocumentDbCollectionDataset.class);

    private DocumentDbCollectionDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public DocumentDbCollectionDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public DocumentDbCollectionDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    @Override
    public DocumentDbCollectionDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    @Override
    public DocumentDbCollectionDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public DocumentDbCollectionDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public DocumentDbCollectionDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    @Override
    public DocumentDbCollectionDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    public Object collectionName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().collectionName();
    }

    public DocumentDbCollectionDataset withCollectionName(Object collectionName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DocumentDbCollectionDatasetTypeProperties();
        }
        this.innerTypeProperties().withCollectionName(collectionName);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model DocumentDbCollectionDataset"));
        }
        this.innerTypeProperties().validate();
    }
}

