/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.parameters;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.K8sTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.enums.ResourceType;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.IParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.DataSourceParameters;
import org.apache.dolphinscheduler.plugin.task.api.parameters.resource.ResourceParametersHelper;
import org.apache.dolphinscheduler.plugin.task.api.utils.VarPoolUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParameters
implements IParameters {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractParameters.class);
    public List<Property> localParams;
    public List<Property> varPool = new ArrayList<Property>();

    @Override
    public abstract boolean checkParameters();

    @Override
    public List<ResourceInfo> getResourceFilesList() {
        return new ArrayList<ResourceInfo>();
    }

    public Map<String, Property> getLocalParametersMap() {
        LinkedHashMap<String, Property> localParametersMaps = new LinkedHashMap<String, Property>();
        if (this.localParams != null) {
            for (Property property : this.localParams) {
                localParametersMaps.put(property.getProp(), property);
            }
        }
        return localParametersMaps;
    }

    public K8sTaskExecutionContext generateK8sTaskExecutionContext(ResourceParametersHelper parametersHelper, int datasource) {
        DataSourceParameters dataSourceParameters = (DataSourceParameters)parametersHelper.getResourceParameters(ResourceType.DATASOURCE, datasource);
        K8sTaskExecutionContext k8sTaskExecutionContext = new K8sTaskExecutionContext();
        k8sTaskExecutionContext.setConnectionParams(Objects.nonNull(dataSourceParameters) ? dataSourceParameters.getConnectionParams() : null);
        return k8sTaskExecutionContext;
    }

    public Map<String, Property> getInputLocalParametersMap() {
        LinkedHashMap<String, Property> localParametersMaps = new LinkedHashMap<String, Property>();
        if (this.localParams != null) {
            for (Property property : this.localParams) {
                if (property.getDirect() != null && !Objects.equals((Object)Direct.IN, (Object)property.getDirect())) continue;
                localParametersMaps.put(property.getProp(), property);
            }
        }
        return localParametersMaps;
    }

    public void setVarPool(List<Property> varPool) {
        this.varPool = varPool;
    }

    public void dealOutParam(Map<String, String> taskOutputParams) {
        List<Property> outProperty = this.getOutProperty(this.localParams);
        if (CollectionUtils.isEmpty(outProperty)) {
            return;
        }
        if (CollectionUtils.isNotEmpty(outProperty) && MapUtils.isNotEmpty(taskOutputParams)) {
            for (Property info : outProperty) {
                String value = taskOutputParams.get(info.getProp());
                if (value == null) continue;
                info.setValue(value);
            }
        }
        this.varPool = VarPoolUtils.mergeVarPool(Lists.newArrayList((Object[])new List[]{this.varPool, outProperty}));
    }

    protected List<Property> getOutProperty(List<Property> params) {
        if (CollectionUtils.isEmpty(params)) {
            return new ArrayList<Property>();
        }
        return params.stream().filter(info -> info.getDirect() == Direct.OUT).collect(Collectors.toList());
    }

    public List<Map<String, String>> getListMapByString(String json) {
        ArrayList<Map<String, String>> allParams = new ArrayList<Map<String, String>>();
        ArrayNode paramsByJson = JSONUtils.parseArray((String)json);
        for (JsonNode jsonNode : paramsByJson) {
            Map param = JSONUtils.toMap((String)jsonNode.toString());
            allParams.add(param);
        }
        return allParams;
    }

    public ResourceParametersHelper getResources() {
        return new ResourceParametersHelper();
    }

    public void addPropertyToValPool(Property property) {
        this.varPool.removeIf(p -> p.getProp().equals(property.getProp()));
        this.varPool.add(property);
    }

    @Generated
    public List<Property> getLocalParams() {
        return this.localParams;
    }

    @Generated
    public List<Property> getVarPool() {
        return this.varPool;
    }

    @Generated
    public void setLocalParams(List<Property> localParams) {
        this.localParams = localParams;
    }
}

