/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VarPoolUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VarPoolUtils.class);

    public static String serializeVarPool(List<Property> varPool) {
        if (CollectionUtils.isEmpty(varPool)) {
            return null;
        }
        return JSONUtils.toJsonString(varPool);
    }

    public static List<Property> deserializeVarPool(String varPoolJson) {
        return JSONUtils.toList((String)varPoolJson, Property.class);
    }

    public static List<Property> mergeVarPoolJsonString(String ... varPoolJsons) {
        if (varPoolJsons == null) {
            return Collections.emptyList();
        }
        return VarPoolUtils.mergeVarPoolJsonString(Lists.newArrayList((Object[])varPoolJsons));
    }

    public static List<Property> mergeVarPoolJsonString(List<String> varPoolJsons) {
        if (CollectionUtils.isEmpty(varPoolJsons)) {
            return null;
        }
        List<List<Property>> varPools = varPoolJsons.stream().map(VarPoolUtils::deserializeVarPool).collect(Collectors.toList());
        return VarPoolUtils.mergeVarPool(varPools);
    }

    public static List<Property> mergeVarPool(List<List<Property>> varPools) {
        if (CollectionUtils.isEmpty(varPools)) {
            return Collections.emptyList();
        }
        if (varPools.size() == 1) {
            return varPools.get(0);
        }
        HashMap<String, Property> result = new HashMap<String, Property>();
        for (List<Property> varPool : varPools) {
            if (CollectionUtils.isEmpty(varPool)) continue;
            for (Property property : varPool) {
                if (!Direct.OUT.equals((Object)property.getDirect())) {
                    log.warn("The direct should be OUT in varPool, but got {}", (Object)property.getDirect());
                    continue;
                }
                result.put(property.getProp(), property);
            }
        }
        return new ArrayList<Property>(result.values());
    }

    public static String subtractVarPoolJson(String varPool, List<String> subtractVarPool) {
        List<Property> varPoolList = VarPoolUtils.deserializeVarPool(varPool);
        List<List<Property>> subtractVarPoolList = subtractVarPool.stream().map(VarPoolUtils::deserializeVarPool).collect(Collectors.toList());
        List<Property> finalVarPool = VarPoolUtils.subtractVarPool(varPoolList, subtractVarPoolList);
        return JSONUtils.toJsonString(finalVarPool);
    }

    public static List<Property> subtractVarPool(List<Property> varPool, List<List<Property>> subtractVarPool) {
        if (CollectionUtils.isEmpty(varPool)) {
            return null;
        }
        if (CollectionUtils.isEmpty(subtractVarPool)) {
            return varPool;
        }
        HashMap<String, Property> subtractVarPoolMap = new HashMap<String, Property>();
        for (List<Property> properties : subtractVarPool) {
            for (Property property : properties) {
                subtractVarPoolMap.put(property.getProp(), property);
            }
        }
        ArrayList<Property> result = new ArrayList<Property>();
        for (Property property : varPool) {
            if (subtractVarPoolMap.containsKey(property.getProp())) continue;
            result.add(property);
        }
        return result;
    }

    @Generated
    private VarPoolUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

