/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ConfigurationType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class NetworkManagerCommitInner {
    @JsonProperty(value="commitId", access=JsonProperty.Access.WRITE_ONLY)
    private String commitId;
    @JsonProperty(value="targetLocations", required=true)
    private List<String> targetLocations;
    @JsonProperty(value="configurationIds")
    private List<String> configurationIds;
    @JsonProperty(value="commitType", required=true)
    private ConfigurationType commitType;
    private static final ClientLogger LOGGER = new ClientLogger(NetworkManagerCommitInner.class);

    public String commitId() {
        return this.commitId;
    }

    public List<String> targetLocations() {
        return this.targetLocations;
    }

    public NetworkManagerCommitInner withTargetLocations(List<String> targetLocations) {
        this.targetLocations = targetLocations;
        return this;
    }

    public List<String> configurationIds() {
        return this.configurationIds;
    }

    public NetworkManagerCommitInner withConfigurationIds(List<String> configurationIds) {
        this.configurationIds = configurationIds;
        return this;
    }

    public ConfigurationType commitType() {
        return this.commitType;
    }

    public NetworkManagerCommitInner withCommitType(ConfigurationType commitType) {
        this.commitType = commitType;
        return this;
    }

    public void validate() {
        if (this.targetLocations() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property targetLocations in model NetworkManagerCommitInner"));
        }
        if (this.commitType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property commitType in model NetworkManagerCommitInner"));
        }
    }
}

