/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.VpnConnectionInner;
import com.azure.resourcemanager.network.fluent.models.VpnGatewayNatRuleInner;
import com.azure.resourcemanager.network.models.BgpSettings;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VpnGatewayIpConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class VpnGatewayProperties {
    @JsonProperty(value="virtualHub")
    private SubResource virtualHub;
    @JsonProperty(value="connections")
    private List<VpnConnectionInner> connections;
    @JsonProperty(value="bgpSettings")
    private BgpSettings bgpSettings;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="vpnGatewayScaleUnit")
    private Integer vpnGatewayScaleUnit;
    @JsonProperty(value="ipConfigurations", access=JsonProperty.Access.WRITE_ONLY)
    private List<VpnGatewayIpConfiguration> ipConfigurations;
    @JsonProperty(value="enableBgpRouteTranslationForNat")
    private Boolean enableBgpRouteTranslationForNat;
    @JsonProperty(value="isRoutingPreferenceInternet")
    private Boolean isRoutingPreferenceInternet;
    @JsonProperty(value="natRules")
    private List<VpnGatewayNatRuleInner> natRules;

    public SubResource virtualHub() {
        return this.virtualHub;
    }

    public VpnGatewayProperties withVirtualHub(SubResource virtualHub) {
        this.virtualHub = virtualHub;
        return this;
    }

    public List<VpnConnectionInner> connections() {
        return this.connections;
    }

    public VpnGatewayProperties withConnections(List<VpnConnectionInner> connections) {
        this.connections = connections;
        return this;
    }

    public BgpSettings bgpSettings() {
        return this.bgpSettings;
    }

    public VpnGatewayProperties withBgpSettings(BgpSettings bgpSettings) {
        this.bgpSettings = bgpSettings;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Integer vpnGatewayScaleUnit() {
        return this.vpnGatewayScaleUnit;
    }

    public VpnGatewayProperties withVpnGatewayScaleUnit(Integer vpnGatewayScaleUnit) {
        this.vpnGatewayScaleUnit = vpnGatewayScaleUnit;
        return this;
    }

    public List<VpnGatewayIpConfiguration> ipConfigurations() {
        return this.ipConfigurations;
    }

    public Boolean enableBgpRouteTranslationForNat() {
        return this.enableBgpRouteTranslationForNat;
    }

    public VpnGatewayProperties withEnableBgpRouteTranslationForNat(Boolean enableBgpRouteTranslationForNat) {
        this.enableBgpRouteTranslationForNat = enableBgpRouteTranslationForNat;
        return this;
    }

    public Boolean isRoutingPreferenceInternet() {
        return this.isRoutingPreferenceInternet;
    }

    public VpnGatewayProperties withIsRoutingPreferenceInternet(Boolean isRoutingPreferenceInternet) {
        this.isRoutingPreferenceInternet = isRoutingPreferenceInternet;
        return this;
    }

    public List<VpnGatewayNatRuleInner> natRules() {
        return this.natRules;
    }

    public VpnGatewayProperties withNatRules(List<VpnGatewayNatRuleInner> natRules) {
        this.natRules = natRules;
        return this;
    }

    public void validate() {
        if (this.connections() != null) {
            this.connections().forEach(e -> e.validate());
        }
        if (this.bgpSettings() != null) {
            this.bgpSettings().validate();
        }
        if (this.ipConfigurations() != null) {
            this.ipConfigurations().forEach(e -> e.validate());
        }
        if (this.natRules() != null) {
            this.natRules().forEach(e -> e.validate());
        }
    }
}

