/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.process;

import java.util.List;
import java.util.Optional;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.dao.entity.DagData;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskRelation;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskRelationLog;
import org.apache.dolphinscheduler.service.model.TaskNode;

public interface ProcessService {
    public Optional<WorkflowInstance> findWorkflowInstanceDetailById(int var1);

    public WorkflowInstance findWorkflowInstanceById(int var1);

    public WorkflowDefinition findWorkflowDefinition(Long var1, int var2);

    public int deleteWorkflowInstanceById(int var1);

    public List<Long> findAllSubWorkflowDefinitionCode(long var1);

    public String getTenantForWorkflow(String var1, int var2);

    public WorkflowInstance findSubWorkflowInstance(Integer var1, Integer var2);

    public WorkflowInstance findParentWorkflowInstance(Integer var1);

    public List<Schedule> queryReleaseSchedulerListByWorkflowDefinitionCode(long var1);

    public DataSource findDataSourceById(int var1);

    public <T> List<T> listUnauthorized(int var1, T[] var2, AuthorizationType var3);

    public User getUserById(int var1);

    public int switchVersion(WorkflowDefinition var1, WorkflowDefinitionLog var2);

    public int switchWorkflowTaskRelationVersion(WorkflowDefinition var1);

    public int switchTaskDefinitionVersion(long var1, int var3);

    public int saveTaskDefine(User var1, long var2, List<TaskDefinitionLog> var4, Boolean var5);

    public int saveWorkflowDefine(User var1, WorkflowDefinition var2, Boolean var3, Boolean var4);

    public int saveTaskRelation(User var1, long var2, long var4, int var6, List<WorkflowTaskRelationLog> var7, List<TaskDefinitionLog> var8, Boolean var9);

    public boolean isTaskOnline(long var1);

    public DAG<Long, TaskNode, TaskNodeRelation> genDagGraph(WorkflowDefinition var1);

    public DagData genDagData(WorkflowDefinition var1);

    public List<WorkflowTaskRelation> findRelationByCode(long var1, int var3);

    public List<TaskNode> transformTask(List<WorkflowTaskRelation> var1, List<TaskDefinitionLog> var2);

    public String findConfigYamlByName(String var1);

    public void forceWorkflowInstanceSuccessByTaskInstanceId(TaskInstance var1);
}

