/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.azure.resourcemanager.compute.fluent.DisksClient;
import com.azure.resourcemanager.compute.fluent.models.DiskInner;
import com.azure.resourcemanager.compute.implementation.DiskImpl;
import com.azure.resourcemanager.compute.models.AccessLevel;
import com.azure.resourcemanager.compute.models.Disk;
import com.azure.resourcemanager.compute.models.Disks;
import com.azure.resourcemanager.compute.models.GrantAccessData;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.AcceptedImpl;
import java.time.Duration;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public class DisksImpl
extends TopLevelModifiableResourcesImpl<Disk, DiskImpl, DiskInner, DisksClient, ComputeManager>
implements Disks {
    private final ClientLogger logger = new ClientLogger(this.getClass());

    public DisksImpl(ComputeManager computeManager) {
        super((InnerSupportsListing)((ComputeManagementClient)computeManager.serviceClient()).getDisks(), (Manager)computeManager);
    }

    @Override
    public String grantAccess(String resourceGroupName, String diskName, AccessLevel accessLevel, int accessDuration) {
        return (String)this.grantAccessAsync(resourceGroupName, diskName, accessLevel, accessDuration).block();
    }

    @Override
    public Mono<String> grantAccessAsync(String resourceGroupName, String diskName, AccessLevel accessLevel, int accessDuration) {
        GrantAccessData grantAccessDataInner = new GrantAccessData();
        grantAccessDataInner.withAccess(accessLevel).withDurationInSeconds(accessDuration);
        return ((DisksClient)this.inner()).grantAccessAsync(resourceGroupName, diskName, grantAccessDataInner).map(accessUriInner -> accessUriInner.accessSas());
    }

    @Override
    public void revokeAccess(String resourceGroupName, String diskName) {
        ((DisksClient)this.inner()).revokeAccess(resourceGroupName, diskName);
    }

    @Override
    public Mono<Void> revokeAccessAsync(String resourceGroupName, String diskName) {
        return ((DisksClient)this.inner()).revokeAccessAsync(resourceGroupName, diskName);
    }

    @Override
    public Accepted<Void> beginDeleteById(String id) {
        return this.beginDeleteByResourceGroup(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public Accepted<Void> beginDeleteByResourceGroup(String resourceGroupName, String name) {
        return AcceptedImpl.newAccepted((ClientLogger)this.logger, (HttpPipeline)((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getHttpPipeline(), (Duration)((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDefaultPollInterval(), () -> (Response)((DisksClient)this.inner()).deleteWithResponseAsync(resourceGroupName, name).block(), Function.identity(), Void.class, null, (Context)Context.NONE);
    }

    protected DiskImpl wrapModel(String name) {
        return new DiskImpl(name, new DiskInner(), (ComputeManager)this.manager());
    }

    protected DiskImpl wrapModel(DiskInner inner) {
        if (inner == null) {
            return null;
        }
        return new DiskImpl(inner.name(), inner, (ComputeManager)this.manager());
    }

    public Disk.DefinitionStages.Blank define(String name) {
        return this.wrapModel(name);
    }
}

