/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import io.kubernetes.client.openapi.models.V1NodeStatus;
import io.kubernetes.client.openapi.models.V1NodeStatusFluent;
import io.kubernetes.client.openapi.models.V1NodeStatusFluentImpl;
import java.util.Objects;

public class V1NodeStatusBuilder
extends V1NodeStatusFluentImpl<V1NodeStatusBuilder>
implements VisitableBuilder<V1NodeStatus, V1NodeStatusBuilder> {
    V1NodeStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1NodeStatusBuilder() {
        this(true);
    }

    public V1NodeStatusBuilder(Boolean validationEnabled) {
        this(new V1NodeStatus(), validationEnabled);
    }

    public V1NodeStatusBuilder(V1NodeStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public V1NodeStatusBuilder(V1NodeStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new V1NodeStatus(), validationEnabled);
    }

    public V1NodeStatusBuilder(V1NodeStatusFluent<?> fluent, V1NodeStatus instance) {
        this(fluent, instance, true);
    }

    public V1NodeStatusBuilder(V1NodeStatusFluent<?> fluent, V1NodeStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAddresses(instance.getAddresses());
        fluent.withAllocatable(instance.getAllocatable());
        fluent.withCapacity(instance.getCapacity());
        fluent.withConditions(instance.getConditions());
        fluent.withConfig(instance.getConfig());
        fluent.withDaemonEndpoints(instance.getDaemonEndpoints());
        fluent.withImages(instance.getImages());
        fluent.withNodeInfo(instance.getNodeInfo());
        fluent.withPhase(instance.getPhase());
        fluent.withVolumesAttached(instance.getVolumesAttached());
        fluent.withVolumesInUse(instance.getVolumesInUse());
        this.validationEnabled = validationEnabled;
    }

    public V1NodeStatusBuilder(V1NodeStatus instance) {
        this(instance, (Boolean)true);
    }

    public V1NodeStatusBuilder(V1NodeStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAddresses(instance.getAddresses());
        this.withAllocatable(instance.getAllocatable());
        this.withCapacity(instance.getCapacity());
        this.withConditions(instance.getConditions());
        this.withConfig(instance.getConfig());
        this.withDaemonEndpoints(instance.getDaemonEndpoints());
        this.withImages(instance.getImages());
        this.withNodeInfo(instance.getNodeInfo());
        this.withPhase(instance.getPhase());
        this.withVolumesAttached(instance.getVolumesAttached());
        this.withVolumesInUse(instance.getVolumesInUse());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public V1NodeStatus build() {
        V1NodeStatus buildable = new V1NodeStatus();
        buildable.setAddresses(this.fluent.getAddresses());
        buildable.setAllocatable(this.fluent.getAllocatable());
        buildable.setCapacity(this.fluent.getCapacity());
        buildable.setConditions(this.fluent.getConditions());
        buildable.setConfig(this.fluent.getConfig());
        buildable.setDaemonEndpoints(this.fluent.getDaemonEndpoints());
        buildable.setImages(this.fluent.getImages());
        buildable.setNodeInfo(this.fluent.getNodeInfo());
        buildable.setPhase(this.fluent.getPhase());
        buildable.setVolumesAttached(this.fluent.getVolumesAttached());
        buildable.setVolumesInUse(this.fluent.getVolumesInUse());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1NodeStatusBuilder that = (V1NodeStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

