/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.extract.base.config;

import java.time.Duration;
import lombok.Generated;

public class NettyClientConfig {
    private int workerThreads;
    private boolean tcpNoDelay;
    private boolean soKeepalive;
    private int sendBufferSize;
    private int receiveBufferSize;
    private int connectTimeoutMillis;
    private long heartBeatIntervalMillis;
    private int defaultRpcTimeoutMillis;

    @Generated
    private static int $default$workerThreads() {
        return Runtime.getRuntime().availableProcessors() * 2;
    }

    @Generated
    private static boolean $default$tcpNoDelay() {
        return true;
    }

    @Generated
    private static boolean $default$soKeepalive() {
        return true;
    }

    @Generated
    private static int $default$sendBufferSize() {
        return 65535;
    }

    @Generated
    private static int $default$receiveBufferSize() {
        return 65535;
    }

    @Generated
    private static int $default$connectTimeoutMillis() {
        return 3000;
    }

    @Generated
    private static long $default$heartBeatIntervalMillis() {
        return Duration.ofSeconds(10L).toMillis();
    }

    @Generated
    private static int $default$defaultRpcTimeoutMillis() {
        return 10000;
    }

    @Generated
    public static NettyClientConfigBuilder builder() {
        return new NettyClientConfigBuilder();
    }

    @Generated
    public int getWorkerThreads() {
        return this.workerThreads;
    }

    @Generated
    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    @Generated
    public boolean isSoKeepalive() {
        return this.soKeepalive;
    }

    @Generated
    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    @Generated
    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    @Generated
    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    @Generated
    public long getHeartBeatIntervalMillis() {
        return this.heartBeatIntervalMillis;
    }

    @Generated
    public int getDefaultRpcTimeoutMillis() {
        return this.defaultRpcTimeoutMillis;
    }

    @Generated
    public void setWorkerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
    }

    @Generated
    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    @Generated
    public void setSoKeepalive(boolean soKeepalive) {
        this.soKeepalive = soKeepalive;
    }

    @Generated
    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    @Generated
    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    @Generated
    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    @Generated
    public void setHeartBeatIntervalMillis(long heartBeatIntervalMillis) {
        this.heartBeatIntervalMillis = heartBeatIntervalMillis;
    }

    @Generated
    public void setDefaultRpcTimeoutMillis(int defaultRpcTimeoutMillis) {
        this.defaultRpcTimeoutMillis = defaultRpcTimeoutMillis;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NettyClientConfig)) {
            return false;
        }
        NettyClientConfig other = (NettyClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWorkerThreads() != other.getWorkerThreads()) {
            return false;
        }
        if (this.isTcpNoDelay() != other.isTcpNoDelay()) {
            return false;
        }
        if (this.isSoKeepalive() != other.isSoKeepalive()) {
            return false;
        }
        if (this.getSendBufferSize() != other.getSendBufferSize()) {
            return false;
        }
        if (this.getReceiveBufferSize() != other.getReceiveBufferSize()) {
            return false;
        }
        if (this.getConnectTimeoutMillis() != other.getConnectTimeoutMillis()) {
            return false;
        }
        if (this.getHeartBeatIntervalMillis() != other.getHeartBeatIntervalMillis()) {
            return false;
        }
        return this.getDefaultRpcTimeoutMillis() == other.getDefaultRpcTimeoutMillis();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NettyClientConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWorkerThreads();
        result = result * 59 + (this.isTcpNoDelay() ? 79 : 97);
        result = result * 59 + (this.isSoKeepalive() ? 79 : 97);
        result = result * 59 + this.getSendBufferSize();
        result = result * 59 + this.getReceiveBufferSize();
        result = result * 59 + this.getConnectTimeoutMillis();
        long $heartBeatIntervalMillis = this.getHeartBeatIntervalMillis();
        result = result * 59 + (int)($heartBeatIntervalMillis >>> 32 ^ $heartBeatIntervalMillis);
        result = result * 59 + this.getDefaultRpcTimeoutMillis();
        return result;
    }

    @Generated
    public String toString() {
        return "NettyClientConfig(workerThreads=" + this.getWorkerThreads() + ", tcpNoDelay=" + this.isTcpNoDelay() + ", soKeepalive=" + this.isSoKeepalive() + ", sendBufferSize=" + this.getSendBufferSize() + ", receiveBufferSize=" + this.getReceiveBufferSize() + ", connectTimeoutMillis=" + this.getConnectTimeoutMillis() + ", heartBeatIntervalMillis=" + this.getHeartBeatIntervalMillis() + ", defaultRpcTimeoutMillis=" + this.getDefaultRpcTimeoutMillis() + ")";
    }

    @Generated
    public NettyClientConfig() {
        this.workerThreads = NettyClientConfig.$default$workerThreads();
        this.tcpNoDelay = NettyClientConfig.$default$tcpNoDelay();
        this.soKeepalive = NettyClientConfig.$default$soKeepalive();
        this.sendBufferSize = NettyClientConfig.$default$sendBufferSize();
        this.receiveBufferSize = NettyClientConfig.$default$receiveBufferSize();
        this.connectTimeoutMillis = NettyClientConfig.$default$connectTimeoutMillis();
        this.heartBeatIntervalMillis = NettyClientConfig.$default$heartBeatIntervalMillis();
        this.defaultRpcTimeoutMillis = NettyClientConfig.$default$defaultRpcTimeoutMillis();
    }

    @Generated
    public NettyClientConfig(int workerThreads, boolean tcpNoDelay, boolean soKeepalive, int sendBufferSize, int receiveBufferSize, int connectTimeoutMillis, long heartBeatIntervalMillis, int defaultRpcTimeoutMillis) {
        this.workerThreads = workerThreads;
        this.tcpNoDelay = tcpNoDelay;
        this.soKeepalive = soKeepalive;
        this.sendBufferSize = sendBufferSize;
        this.receiveBufferSize = receiveBufferSize;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.heartBeatIntervalMillis = heartBeatIntervalMillis;
        this.defaultRpcTimeoutMillis = defaultRpcTimeoutMillis;
    }

    @Generated
    public static class NettyClientConfigBuilder {
        @Generated
        private boolean workerThreads$set;
        @Generated
        private int workerThreads$value;
        @Generated
        private boolean tcpNoDelay$set;
        @Generated
        private boolean tcpNoDelay$value;
        @Generated
        private boolean soKeepalive$set;
        @Generated
        private boolean soKeepalive$value;
        @Generated
        private boolean sendBufferSize$set;
        @Generated
        private int sendBufferSize$value;
        @Generated
        private boolean receiveBufferSize$set;
        @Generated
        private int receiveBufferSize$value;
        @Generated
        private boolean connectTimeoutMillis$set;
        @Generated
        private int connectTimeoutMillis$value;
        @Generated
        private boolean heartBeatIntervalMillis$set;
        @Generated
        private long heartBeatIntervalMillis$value;
        @Generated
        private boolean defaultRpcTimeoutMillis$set;
        @Generated
        private int defaultRpcTimeoutMillis$value;

        @Generated
        NettyClientConfigBuilder() {
        }

        @Generated
        public NettyClientConfigBuilder workerThreads(int workerThreads) {
            this.workerThreads$value = workerThreads;
            this.workerThreads$set = true;
            return this;
        }

        @Generated
        public NettyClientConfigBuilder tcpNoDelay(boolean tcpNoDelay) {
            this.tcpNoDelay$value = tcpNoDelay;
            this.tcpNoDelay$set = true;
            return this;
        }

        @Generated
        public NettyClientConfigBuilder soKeepalive(boolean soKeepalive) {
            this.soKeepalive$value = soKeepalive;
            this.soKeepalive$set = true;
            return this;
        }

        @Generated
        public NettyClientConfigBuilder sendBufferSize(int sendBufferSize) {
            this.sendBufferSize$value = sendBufferSize;
            this.sendBufferSize$set = true;
            return this;
        }

        @Generated
        public NettyClientConfigBuilder receiveBufferSize(int receiveBufferSize) {
            this.receiveBufferSize$value = receiveBufferSize;
            this.receiveBufferSize$set = true;
            return this;
        }

        @Generated
        public NettyClientConfigBuilder connectTimeoutMillis(int connectTimeoutMillis) {
            this.connectTimeoutMillis$value = connectTimeoutMillis;
            this.connectTimeoutMillis$set = true;
            return this;
        }

        @Generated
        public NettyClientConfigBuilder heartBeatIntervalMillis(long heartBeatIntervalMillis) {
            this.heartBeatIntervalMillis$value = heartBeatIntervalMillis;
            this.heartBeatIntervalMillis$set = true;
            return this;
        }

        @Generated
        public NettyClientConfigBuilder defaultRpcTimeoutMillis(int defaultRpcTimeoutMillis) {
            this.defaultRpcTimeoutMillis$value = defaultRpcTimeoutMillis;
            this.defaultRpcTimeoutMillis$set = true;
            return this;
        }

        @Generated
        public NettyClientConfig build() {
            int workerThreads$value = this.workerThreads$value;
            if (!this.workerThreads$set) {
                workerThreads$value = NettyClientConfig.$default$workerThreads();
            }
            boolean tcpNoDelay$value = this.tcpNoDelay$value;
            if (!this.tcpNoDelay$set) {
                tcpNoDelay$value = NettyClientConfig.$default$tcpNoDelay();
            }
            boolean soKeepalive$value = this.soKeepalive$value;
            if (!this.soKeepalive$set) {
                soKeepalive$value = NettyClientConfig.$default$soKeepalive();
            }
            int sendBufferSize$value = this.sendBufferSize$value;
            if (!this.sendBufferSize$set) {
                sendBufferSize$value = NettyClientConfig.$default$sendBufferSize();
            }
            int receiveBufferSize$value = this.receiveBufferSize$value;
            if (!this.receiveBufferSize$set) {
                receiveBufferSize$value = NettyClientConfig.$default$receiveBufferSize();
            }
            int connectTimeoutMillis$value = this.connectTimeoutMillis$value;
            if (!this.connectTimeoutMillis$set) {
                connectTimeoutMillis$value = NettyClientConfig.$default$connectTimeoutMillis();
            }
            long heartBeatIntervalMillis$value = this.heartBeatIntervalMillis$value;
            if (!this.heartBeatIntervalMillis$set) {
                heartBeatIntervalMillis$value = NettyClientConfig.$default$heartBeatIntervalMillis();
            }
            int defaultRpcTimeoutMillis$value = this.defaultRpcTimeoutMillis$value;
            if (!this.defaultRpcTimeoutMillis$set) {
                defaultRpcTimeoutMillis$value = NettyClientConfig.$default$defaultRpcTimeoutMillis();
            }
            return new NettyClientConfig(workerThreads$value, tcpNoDelay$value, soKeepalive$value, sendBufferSize$value, receiveBufferSize$value, connectTimeoutMillis$value, heartBeatIntervalMillis$value, defaultRpcTimeoutMillis$value);
        }

        @Generated
        public String toString() {
            return "NettyClientConfig.NettyClientConfigBuilder(workerThreads$value=" + this.workerThreads$value + ", tcpNoDelay$value=" + this.tcpNoDelay$value + ", soKeepalive$value=" + this.soKeepalive$value + ", sendBufferSize$value=" + this.sendBufferSize$value + ", receiveBufferSize$value=" + this.receiveBufferSize$value + ", connectTimeoutMillis$value=" + this.connectTimeoutMillis$value + ", heartBeatIntervalMillis$value=" + this.heartBeatIntervalMillis$value + ", defaultRpcTimeoutMillis$value=" + this.defaultRpcTimeoutMillis$value + ")";
        }
    }
}

