/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.alts.internal.AltsChannelCrypter;
import io.grpc.alts.internal.AltsHandshakerClient;
import io.grpc.alts.internal.AltsHandshakerOptions;
import io.grpc.alts.internal.AltsInternalContext;
import io.grpc.alts.internal.AltsTsiFrameProtector;
import io.grpc.alts.internal.HandshakerServiceGrpc;
import io.grpc.alts.internal.TsiFrameProtector;
import io.grpc.alts.internal.TsiHandshaker;
import io.grpc.alts.internal.TsiPeer;
import io.grpc.netty.shaded.io.netty.buffer.ByteBufAllocator;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AltsTsiHandshaker
implements TsiHandshaker {
    private static final Logger logger = Logger.getLogger(AltsTsiHandshaker.class.getName());
    public static final String TSI_SERVICE_ACCOUNT_PEER_PROPERTY = "service_account";
    private final boolean isClient;
    private final AltsHandshakerClient handshaker;
    private ByteBuffer outputFrame;

    private AltsTsiHandshaker(boolean isClient, HandshakerServiceGrpc.HandshakerServiceStub stub, AltsHandshakerOptions options) {
        this.isClient = isClient;
        this.handshaker = new AltsHandshakerClient(stub, options);
    }

    @VisibleForTesting
    AltsTsiHandshaker(boolean isClient, AltsHandshakerClient handshaker) {
        this.isClient = isClient;
        this.handshaker = handshaker;
    }

    @Override
    public boolean processBytesFromPeer(ByteBuffer bytes) throws GeneralSecurityException {
        if (this.outputFrame == null && this.isClient) {
            return true;
        }
        if (this.outputFrame != null && this.outputFrame.hasRemaining()) {
            return true;
        }
        int remaining = bytes.remaining();
        if (this.outputFrame == null) {
            Preconditions.checkState((!this.isClient ? 1 : 0) != 0, (Object)"Client handshaker should not process any frame at the beginning.");
            this.outputFrame = this.handshaker.startServerHandshake(bytes);
        } else {
            this.outputFrame = this.handshaker.next(bytes);
        }
        if (this.handshaker.isFinished() || this.outputFrame.hasRemaining()) {
            return true;
        }
        if (!bytes.hasRemaining()) {
            return false;
        }
        Preconditions.checkState((bytes.remaining() < remaining ? 1 : 0) != 0, (Object)"Handshaker did not consume any bytes.");
        return this.processBytesFromPeer(bytes);
    }

    @Override
    public TsiPeer extractPeer() throws GeneralSecurityException {
        Preconditions.checkState((!this.isInProgress() ? 1 : 0) != 0, (Object)"Handshake is not complete.");
        ArrayList peerProperties = new ArrayList();
        peerProperties.add(new TsiPeer.StringProperty(TSI_SERVICE_ACCOUNT_PEER_PROPERTY, this.handshaker.getResult().getPeerIdentity().getServiceAccount()));
        return new TsiPeer(peerProperties);
    }

    @Override
    public Object extractPeerObject() throws GeneralSecurityException {
        Preconditions.checkState((!this.isInProgress() ? 1 : 0) != 0, (Object)"Handshake is not complete.");
        return new AltsInternalContext(this.handshaker.getResult());
    }

    public static TsiHandshaker newClient(HandshakerServiceGrpc.HandshakerServiceStub stub, AltsHandshakerOptions options) {
        return new AltsTsiHandshaker(true, stub, options);
    }

    public static TsiHandshaker newServer(HandshakerServiceGrpc.HandshakerServiceStub stub, AltsHandshakerOptions options) {
        return new AltsTsiHandshaker(false, stub, options);
    }

    @Override
    public void getBytesToSendToPeer(ByteBuffer bytes) throws GeneralSecurityException {
        if (this.outputFrame == null) {
            if (this.isClient) {
                this.outputFrame = this.handshaker.startClientHandshake();
            } else {
                return;
            }
        }
        ByteBuffer outputFrameAlias = this.outputFrame;
        if (this.outputFrame.remaining() > bytes.remaining()) {
            outputFrameAlias = this.outputFrame.duplicate();
            ((Buffer)outputFrameAlias).limit(outputFrameAlias.position() + bytes.remaining());
        }
        bytes.put(outputFrameAlias);
        ((Buffer)this.outputFrame).position(outputFrameAlias.position());
    }

    @Override
    public boolean isInProgress() {
        return !this.handshaker.isFinished() || this.outputFrame.hasRemaining();
    }

    @Override
    public TsiFrameProtector createFrameProtector(int maxFrameSize, ByteBufAllocator alloc) {
        Preconditions.checkState((!this.isInProgress() ? 1 : 0) != 0, (Object)"Handshake is not complete.");
        byte[] key = this.handshaker.getKey();
        Preconditions.checkState((key.length == AltsChannelCrypter.getKeyLength() ? 1 : 0) != 0, (Object)"Bad key length.");
        int peerMaxFrameSize = this.handshaker.getResult().getMaxFrameSize();
        if (peerMaxFrameSize != 0) {
            maxFrameSize = Math.min(peerMaxFrameSize, AltsTsiFrameProtector.getMaxFrameSize());
            maxFrameSize = Math.max(AltsTsiFrameProtector.getMinFrameSize(), maxFrameSize);
        }
        logger.log(Level.FINE, "Maximum frame size value is {0}.", maxFrameSize);
        return new AltsTsiFrameProtector(maxFrameSize, new AltsChannelCrypter(key, this.isClient), alloc);
    }

    @Override
    public TsiFrameProtector createFrameProtector(ByteBufAllocator alloc) {
        return this.createFrameProtector(AltsTsiFrameProtector.getMinFrameSize(), alloc);
    }

    @Override
    public void close() {
        this.handshaker.close();
    }
}

