/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.VirtualWanProperties;
import com.azure.resourcemanager.network.models.OfficeTrafficCategory;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class VirtualWanInner
extends Resource {
    @JsonProperty(value="properties")
    private VirtualWanProperties innerProperties;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="id")
    private String id;

    private VirtualWanProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public VirtualWanInner withId(String id) {
        this.id = id;
        return this;
    }

    public VirtualWanInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualWanInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Boolean disableVpnEncryption() {
        return this.innerProperties() == null ? null : this.innerProperties().disableVpnEncryption();
    }

    public VirtualWanInner withDisableVpnEncryption(Boolean disableVpnEncryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualWanProperties();
        }
        this.innerProperties().withDisableVpnEncryption(disableVpnEncryption);
        return this;
    }

    public List<SubResource> virtualHubs() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualHubs();
    }

    public List<SubResource> vpnSites() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnSites();
    }

    public Boolean allowBranchToBranchTraffic() {
        return this.innerProperties() == null ? null : this.innerProperties().allowBranchToBranchTraffic();
    }

    public VirtualWanInner withAllowBranchToBranchTraffic(Boolean allowBranchToBranchTraffic) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualWanProperties();
        }
        this.innerProperties().withAllowBranchToBranchTraffic(allowBranchToBranchTraffic);
        return this;
    }

    public Boolean allowVnetToVnetTraffic() {
        return this.innerProperties() == null ? null : this.innerProperties().allowVnetToVnetTraffic();
    }

    public VirtualWanInner withAllowVnetToVnetTraffic(Boolean allowVnetToVnetTraffic) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualWanProperties();
        }
        this.innerProperties().withAllowVnetToVnetTraffic(allowVnetToVnetTraffic);
        return this;
    }

    public OfficeTrafficCategory office365LocalBreakoutCategory() {
        return this.innerProperties() == null ? null : this.innerProperties().office365LocalBreakoutCategory();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String typePropertiesType() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    public VirtualWanInner withTypePropertiesType(String type) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualWanProperties();
        }
        this.innerProperties().withType(type);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

