/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.jdbc;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public final class KeyUtils {
    public static boolean isParent(String parentPath, String childPath) {
        String[] childSplit;
        if (StringUtils.isEmpty((CharSequence)parentPath)) {
            throw new IllegalArgumentException("Invalid parent path " + parentPath);
        }
        if (StringUtils.isEmpty((CharSequence)childPath)) {
            throw new IllegalArgumentException("Invalid child path " + childPath);
        }
        String[] parentSplit = KeyUtils.removeLastSlash(parentPath).split("/");
        if (parentSplit.length >= (childSplit = KeyUtils.removeLastSlash(childPath).split("/")).length) {
            return false;
        }
        for (int i = 0; i < parentSplit.length; ++i) {
            if (parentSplit[i].equals(childSplit[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSamePath(String path1, String path2) {
        return KeyUtils.removeLastSlash(path1).equals(path2);
    }

    private static String removeLastSlash(String path) {
        int length;
        Preconditions.checkNotNull((Object)path, (Object)"path is null");
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Invalid path " + path);
        }
        for (length = path.length() - 1; length >= 0 && path.charAt(length) == '/'; --length) {
        }
        if (length == -1) {
            return "/";
        }
        return path.substring(0, length + 1);
    }

    @Generated
    private KeyUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

