/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cdn.fluent.RoutesClient;
import com.azure.resourcemanager.cdn.fluent.models.RouteInner;
import com.azure.resourcemanager.cdn.implementation.CdnManagementClientImpl;
import com.azure.resourcemanager.cdn.models.RouteListResult;
import com.azure.resourcemanager.cdn.models.RouteUpdateParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class RoutesClientImpl
implements RoutesClient {
    private final RoutesService service;
    private final CdnManagementClientImpl client;

    RoutesClientImpl(CdnManagementClientImpl client) {
        this.service = (RoutesService)RestProxy.create(RoutesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RouteInner>> listByEndpointSinglePageAsync(String resourceGroupName, String profileName, String endpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByEndpoint(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RouteListResult)res.getValue()).value(), ((RouteListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RouteInner>> listByEndpointSinglePageAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByEndpoint(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RouteListResult)res.getValue()).value(), ((RouteListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RouteInner> listByEndpointAsync(String resourceGroupName, String profileName, String endpointName) {
        return new PagedFlux(() -> this.listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName), nextLink -> this.listByEndpointNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RouteInner> listByEndpointAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        return new PagedFlux(() -> this.listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName, context), nextLink -> this.listByEndpointNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RouteInner> listByEndpoint(String resourceGroupName, String profileName, String endpointName) {
        return new PagedIterable(this.listByEndpointAsync(resourceGroupName, profileName, endpointName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RouteInner> listByEndpoint(String resourceGroupName, String profileName, String endpointName, Context context) {
        return new PagedIterable(this.listByEndpointAsync(resourceGroupName, profileName, endpointName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RouteInner>> getWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String routeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (routeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routeName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, routeName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RouteInner>> getWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String routeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (routeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routeName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, routeName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RouteInner> getAsync(String resourceGroupName, String profileName, String endpointName, String routeName) {
        return this.getWithResponseAsync(resourceGroupName, profileName, endpointName, routeName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RouteInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RouteInner get(String resourceGroupName, String profileName, String endpointName, String routeName) {
        return (RouteInner)((Object)this.getAsync(resourceGroupName, profileName, endpointName, routeName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RouteInner> getWithResponse(String resourceGroupName, String profileName, String endpointName, String routeName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, profileName, endpointName, routeName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (routeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routeName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (route == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter route is required and cannot be null."));
        }
        route.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, routeName, this.client.getSubscriptionId(), this.client.getApiVersion(), route, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (routeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routeName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (route == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter route is required and cannot be null."));
        }
        route.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, routeName, this.client.getSubscriptionId(), this.client.getApiVersion(), route, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<RouteInner>, RouteInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, profileName, endpointName, routeName, route);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RouteInner.class), (Type)((Object)RouteInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<RouteInner>, RouteInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, profileName, endpointName, routeName, route, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RouteInner.class), (Type)((Object)RouteInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RouteInner>, RouteInner> beginCreate(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route) {
        return this.beginCreateAsync(resourceGroupName, profileName, endpointName, routeName, route).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RouteInner>, RouteInner> beginCreate(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route, Context context) {
        return this.beginCreateAsync(resourceGroupName, profileName, endpointName, routeName, route, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RouteInner> createAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route) {
        return this.beginCreateAsync(resourceGroupName, profileName, endpointName, routeName, route).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RouteInner> createAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route, Context context) {
        return this.beginCreateAsync(resourceGroupName, profileName, endpointName, routeName, route, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RouteInner create(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route) {
        return (RouteInner)((Object)this.createAsync(resourceGroupName, profileName, endpointName, routeName, route).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RouteInner create(String resourceGroupName, String profileName, String endpointName, String routeName, RouteInner route, Context context) {
        return (RouteInner)((Object)this.createAsync(resourceGroupName, profileName, endpointName, routeName, route, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (routeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routeName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (routeUpdateProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routeUpdateProperties is required and cannot be null."));
        }
        routeUpdateProperties.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, routeName, this.client.getSubscriptionId(), this.client.getApiVersion(), routeUpdateProperties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (routeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routeName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (routeUpdateProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routeUpdateProperties is required and cannot be null."));
        }
        routeUpdateProperties.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, routeName, this.client.getSubscriptionId(), this.client.getApiVersion(), routeUpdateProperties, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<RouteInner>, RouteInner> beginUpdateAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, profileName, endpointName, routeName, routeUpdateProperties);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RouteInner.class), (Type)((Object)RouteInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<RouteInner>, RouteInner> beginUpdateAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, profileName, endpointName, routeName, routeUpdateProperties, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RouteInner.class), (Type)((Object)RouteInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RouteInner>, RouteInner> beginUpdate(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties) {
        return this.beginUpdateAsync(resourceGroupName, profileName, endpointName, routeName, routeUpdateProperties).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RouteInner>, RouteInner> beginUpdate(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties, Context context) {
        return this.beginUpdateAsync(resourceGroupName, profileName, endpointName, routeName, routeUpdateProperties, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RouteInner> updateAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties) {
        return this.beginUpdateAsync(resourceGroupName, profileName, endpointName, routeName, routeUpdateProperties).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RouteInner> updateAsync(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties, Context context) {
        return this.beginUpdateAsync(resourceGroupName, profileName, endpointName, routeName, routeUpdateProperties, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RouteInner update(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties) {
        return (RouteInner)((Object)this.updateAsync(resourceGroupName, profileName, endpointName, routeName, routeUpdateProperties).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RouteInner update(String resourceGroupName, String profileName, String endpointName, String routeName, RouteUpdateParameters routeUpdateProperties, Context context) {
        return (RouteInner)((Object)this.updateAsync(resourceGroupName, profileName, endpointName, routeName, routeUpdateProperties, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String routeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (routeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routeName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, routeName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String routeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (routeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter routeName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, routeName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName, String routeName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, profileName, endpointName, routeName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName, String routeName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, profileName, endpointName, routeName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String profileName, String endpointName, String routeName) {
        return this.beginDeleteAsync(resourceGroupName, profileName, endpointName, routeName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String profileName, String endpointName, String routeName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, profileName, endpointName, routeName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String profileName, String endpointName, String routeName) {
        return this.beginDeleteAsync(resourceGroupName, profileName, endpointName, routeName).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String profileName, String endpointName, String routeName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, profileName, endpointName, routeName, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String profileName, String endpointName, String routeName) {
        this.deleteAsync(resourceGroupName, profileName, endpointName, routeName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String profileName, String endpointName, String routeName, Context context) {
        this.deleteAsync(resourceGroupName, profileName, endpointName, routeName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RouteInner>> listByEndpointNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByEndpointNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RouteListResult)res.getValue()).value(), ((RouteListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RouteInner>> listByEndpointNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByEndpointNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RouteListResult)res.getValue()).value(), ((RouteListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CdnManagementClientR")
    private static interface RoutesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/routes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RouteListResult>> listByEndpoint(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/routes/{routeName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RouteInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="routeName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/routes/{routeName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="routeName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") RouteInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/routes/{routeName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="routeName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") RouteUpdateParameters var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/routes/{routeName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="routeName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RouteListResult>> listByEndpointNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

