/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.server.master.engine.AbstractLifecycleEvent;
import org.apache.dolphinscheduler.server.master.engine.ILifecycleEventHandler;
import org.apache.dolphinscheduler.server.master.engine.ILifecycleEventType;
import org.apache.dolphinscheduler.server.master.engine.WorkflowEventBus;
import org.apache.dolphinscheduler.server.master.engine.exceptions.WorkflowEventFireException;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.server.master.runner.IWorkflowExecuteContext;
import org.apache.dolphinscheduler.server.master.utils.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowEventBusFireWorker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowEventBusFireWorker.class);
    private final Map<Integer, IWorkflowExecutionRunnable> registeredWorkflowExecuteRunnableMap = new ConcurrentHashMap<Integer, IWorkflowExecutionRunnable>();
    private final Map<ILifecycleEventType, ILifecycleEventHandler> eventHandlerMap = new ConcurrentHashMap<ILifecycleEventType, ILifecycleEventHandler>();

    public void registerEventHandler(ILifecycleEventHandler eventHandler) {
        Preconditions.checkArgument((eventHandler != null ? 1 : 0) != 0, (Object)"event handler cannot be null");
        Preconditions.checkArgument((eventHandler.matchEventType() != null ? 1 : 0) != 0, (Object)"event type cannot be null");
        this.eventHandlerMap.put(eventHandler.matchEventType(), eventHandler);
    }

    public void registerWorkflowEventBus(IWorkflowExecutionRunnable workflowExecutionRunnable) {
        IWorkflowExecuteContext workflowExecuteContext = workflowExecutionRunnable.getWorkflowExecuteContext();
        WorkflowInstance workflowInstance = workflowExecuteContext.getWorkflowInstance();
        Integer workflowInstanceId = workflowInstance.getId();
        String workflowInstanceName = workflowInstance.getName();
        Preconditions.checkState((!this.registeredWorkflowExecuteRunnableMap.containsKey(workflowInstanceId) ? 1 : 0) != 0, (String)"WorkflowExecuteRunnable(%s/%s already registered at WorkflowEventBusFireWorker", (Object)workflowInstanceId, (Object)workflowInstanceName);
        this.registeredWorkflowExecuteRunnableMap.put(workflowInstanceId, workflowExecutionRunnable);
    }

    public void unRegisterWorkflowEventBus(IWorkflowExecutionRunnable workflowExecutionRunnable) {
        IWorkflowExecuteContext workflowExecuteContext = workflowExecutionRunnable.getWorkflowExecuteContext();
        WorkflowInstance workflowInstance = workflowExecuteContext.getWorkflowInstance();
        Integer workflowInstanceId = workflowInstance.getId();
        this.registeredWorkflowExecuteRunnableMap.remove(workflowInstanceId, workflowExecutionRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAllRegisteredEvent() {
        List<IWorkflowExecutionRunnable> workflowExecutionRunnables = this.getWaitingFireWorkflowExecutionRunnables();
        if (CollectionUtils.isEmpty(workflowExecutionRunnables)) {
            return;
        }
        for (IWorkflowExecutionRunnable workflowExecutionRunnable : workflowExecutionRunnables) {
            Integer workflowInstanceId = workflowExecutionRunnable.getId();
            String workflowInstanceName = workflowExecutionRunnable.getName();
            try {
                LogUtils.setWorkflowInstanceIdMDC((Integer)workflowInstanceId);
                this.doFireSingleWorkflowEventBus(workflowExecutionRunnable);
            }
            catch (Exception ex) {
                log.error("Fire event failed for WorkflowExecuteRunnable: {}", (Object)workflowInstanceName, (Object)ex);
            }
            finally {
                LogUtils.removeWorkflowInstanceIdMDC();
            }
        }
    }

    public int getRegisteredWorkflowExecuteRunnableSize() {
        return this.registeredWorkflowExecuteRunnableMap.size();
    }

    private List<IWorkflowExecutionRunnable> getWaitingFireWorkflowExecutionRunnables() {
        if (MapUtils.isEmpty(this.registeredWorkflowExecuteRunnableMap)) {
            return Collections.emptyList();
        }
        return this.registeredWorkflowExecuteRunnableMap.values().stream().filter(workflowExecuteRunnable -> !workflowExecuteRunnable.getWorkflowEventBus().isEmpty()).collect(Collectors.toList());
    }

    private void doFireSingleWorkflowEventBus(IWorkflowExecutionRunnable workflowExecutionRunnable) {
        WorkflowEventBus workflowEventBus = workflowExecutionRunnable.getWorkflowEventBus();
        while (!workflowEventBus.isEmpty()) {
            Optional eventOptional = workflowEventBus.poll();
            if (!eventOptional.isPresent()) {
                return;
            }
            AbstractLifecycleEvent lifecycleEvent = (AbstractLifecycleEvent)((Object)eventOptional.get());
            try {
                workflowEventBus.getWorkflowEventBusSummary().increaseFireSuccessEventCount();
                this.doFireSingleEvent(workflowExecutionRunnable, lifecycleEvent);
            }
            catch (Exception ex) {
                if (ExceptionUtils.isDatabaseConnectedFailedException(ex)) {
                    workflowEventBus.publish(lifecycleEvent);
                    ThreadUtils.sleep((long)5000L);
                    return;
                }
                workflowEventBus.getWorkflowEventBusSummary().decreaseFireSuccessEventCount();
                workflowEventBus.getWorkflowEventBusSummary().increaseFireFailedEventCount();
                throw new WorkflowEventFireException(lifecycleEvent, (Throwable)ex);
            }
        }
    }

    private void doFireSingleEvent(IWorkflowExecutionRunnable workflowExecutionRunnable, AbstractLifecycleEvent event) {
        ILifecycleEventHandler lifecycleEventHandler = this.eventHandlerMap.get(event.getEventType());
        if (lifecycleEventHandler == null) {
            throw new RuntimeException("No EventHandler found for event: " + event.getEventType());
        }
        lifecycleEventHandler.handle(workflowExecutionRunnable, event);
    }
}

