/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.executor.plugin.fake;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.parameters.LogicFakeTaskParameters;
import org.apache.dolphinscheduler.plugin.task.api.parser.TaskOutputParameterParser;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.AbstractLogicTask;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.ITaskParameterDeserializer;
import org.apache.dolphinscheduler.server.master.exception.MasterTaskExecuteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public class LogicFakeTask
extends AbstractLogicTask<LogicFakeTaskParameters> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogicFakeTask.class);
    private volatile Process process;

    public LogicFakeTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.onTaskRunning();
    }

    @Override
    public void start() throws MasterTaskExecuteException {
        try {
            log.info("Begin to execute LogicFakeTask: {}", (Object)this.taskExecutionContext.getTaskName());
            String shellScript = ParameterUtils.convertParameterPlaceholders((String)((LogicFakeTaskParameters)this.taskParameters).getShellScript(), (Map)ParameterUtils.convert((Map)this.taskExecutionContext.getPrepareParamsMap()));
            if (StringUtils.isNotEmpty((CharSequence)this.taskExecutionContext.getEnvironmentConfig())) {
                shellScript = this.taskExecutionContext.getEnvironmentConfig() + "\n" + shellScript;
            }
            ProcessBuilder processBuilder = new ProcessBuilder("/bin/sh", "-c", shellScript);
            processBuilder.redirectErrorStream(true);
            this.process = processBuilder.start();
            Future<Map<String, String>> parseVarPoolFuture = this.parseVarPool();
            int exitCode = this.process.waitFor();
            log.info("LogicFakeTask: {} execute finished with exit code: {}", (Object)this.taskExecutionContext.getTaskName(), (Object)exitCode);
            if (this.taskExecutionStatus == TaskExecutionStatus.KILL) {
                try {
                    parseVarPoolFuture.get(1L, TimeUnit.SECONDS);
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
                log.info("LogicFakeTask: {} has been killed", (Object)this.taskExecutionContext.getTaskName());
                return;
            }
            Map<String, String> taskOutputParams = parseVarPoolFuture.get();
            if (exitCode == 0) {
                log.info("LogicFakeTask: {} execute success", (Object)this.taskExecutionContext.getTaskName());
                ((LogicFakeTaskParameters)this.taskParameters).dealOutParam(taskOutputParams);
                this.taskExecutionContext.setVarPool(((LogicFakeTaskParameters)this.taskParameters).getVarPool());
                this.onTaskSuccess();
            } else {
                log.info("LogicFakeTask: {} execute failed", (Object)this.taskExecutionContext.getTaskName());
                this.onTaskFailed();
            }
        }
        catch (Exception ex) {
            throw new MasterTaskExecuteException("FakeTask execute failed", ex);
        }
    }

    @Override
    public void pause() throws MasterTaskExecuteException {
        log.info("LogicFakeTask: {} doesn't support pause", (Object)this.taskExecutionContext.getTaskName());
    }

    @Override
    public void kill() throws MasterTaskExecuteException {
        if (this.process != null && this.process.isAlive()) {
            this.onTaskKilled();
            this.process.destroyForcibly();
            log.info("Kill LogicFakeTask: {} succeed", (Object)this.taskExecutionContext.getTaskName());
        }
    }

    @Override
    public ITaskParameterDeserializer<LogicFakeTaskParameters> getTaskParameterDeserializer() {
        return taskParamsJson -> (LogicFakeTaskParameters)JSONUtils.parseObject((String)taskParamsJson, (TypeReference)new TypeReference<LogicFakeTaskParameters>(){});
    }

    private Future<Map<String, String>> parseVarPool() {
        ScheduledExecutorService varPoolParseThreadPool = ThreadUtils.newSingleDaemonScheduledExecutorService((String)("ResolveOutputLog-thread-" + this.taskExecutionContext.getTaskName()));
        Future<Map<String, String>> future = varPoolParseThreadPool.submit(() -> {
            TaskOutputParameterParser taskOutputParameterParser = new TaskOutputParameterParser();
            try (BufferedReader inReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));){
                String line;
                while ((line = inReader.readLine()) != null) {
                    log.info(line);
                    taskOutputParameterParser.appendParseLog(line);
                }
            }
            catch (Exception e) {
                log.error("Parse var pool error", (Throwable)e);
            }
            return taskOutputParameterParser.getTaskOutputParams();
        });
        varPoolParseThreadPool.shutdown();
        return future;
    }
}

