/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.controller.builder;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.extended.controller.Controllers;
import io.kubernetes.client.extended.controller.DefaultControllerWatch;
import io.kubernetes.client.extended.controller.reconciler.Request;
import io.kubernetes.client.extended.workqueue.WorkQueue;
import java.time.Duration;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;

public class ControllerWatchBuilder<ApiType extends KubernetesObject> {
    private Function<ApiType, Request> workKeyGenerator;
    private WorkQueue<Request> workQueue;
    private Class<ApiType> apiTypeClass;
    private Duration resyncPeriod = Duration.ZERO;
    private Predicate<ApiType> onAddFilterPredicate;
    private BiPredicate<ApiType, ApiType> onUpdateFilterPredicate;
    private BiPredicate<ApiType, Boolean> onDeleteFilterPredicate;

    ControllerWatchBuilder(Class<ApiType> apiTypeClass, WorkQueue<Request> workQueue) {
        this.apiTypeClass = apiTypeClass;
        this.workKeyGenerator = Controllers.defaultReflectiveKeyFunc();
        this.workQueue = workQueue;
    }

    public ControllerWatchBuilder<ApiType> withOnAddFilter(Predicate<ApiType> filter) {
        this.onAddFilterPredicate = filter;
        return this;
    }

    public ControllerWatchBuilder<ApiType> withOnUpdateFilter(BiPredicate<ApiType, ApiType> filter) {
        this.onUpdateFilterPredicate = filter;
        return this;
    }

    public ControllerWatchBuilder<ApiType> withOnDeleteFilter(BiPredicate<ApiType, Boolean> filter) {
        this.onDeleteFilterPredicate = filter;
        return this;
    }

    public ControllerWatchBuilder<ApiType> withWorkQueueKeyFunc(Function<ApiType, Request> workKeyGenerator) {
        this.workKeyGenerator = workKeyGenerator;
        return this;
    }

    public ControllerWatchBuilder<ApiType> withResyncPeriod(Duration resyncPeriod) {
        this.resyncPeriod = resyncPeriod;
        return this;
    }

    public DefaultControllerWatch<ApiType> build() throws IllegalStateException {
        DefaultControllerWatch<ApiType> workQueueHandler = new DefaultControllerWatch<ApiType>(this.apiTypeClass, this.workQueue, this.workKeyGenerator, this.resyncPeriod);
        workQueueHandler.setOnAddFilterPredicate(this.onAddFilterPredicate);
        workQueueHandler.setOnUpdateFilterPredicate(this.onUpdateFilterPredicate);
        workQueueHandler.setOnDeleteFilterPredicate(this.onDeleteFilterPredicate);
        return workQueueHandler;
    }
}

