/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.executor.plugin.subworkflow;

import java.io.Serializable;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.extract.base.client.Clients;
import org.apache.dolphinscheduler.extract.master.IWorkflowControlClient;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstancePauseRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstancePauseResponse;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceRecoverFailureTasksRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceRecoverFailureTasksResponse;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceRecoverSuspendTasksRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceRecoverSuspendTasksResponse;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceStopRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowInstanceStopResponse;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowManualTriggerRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowManualTriggerResponse;
import org.apache.dolphinscheduler.server.master.engine.executor.plugin.subworkflow.trigger.SubWorkflowManualTrigger;
import org.apache.dolphinscheduler.server.master.engine.workflow.trigger.WorkflowInstanceRecoverFailureTaskTrigger;
import org.apache.dolphinscheduler.server.master.engine.workflow.trigger.WorkflowInstanceRecoverSuspendTaskTrigger;
import org.apache.dolphinscheduler.server.master.exception.MasterTaskExecuteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubWorkflowControlClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SubWorkflowControlClient.class);
    @Autowired
    private WorkflowInstanceDao workflowInstanceDao;
    @Autowired
    private SubWorkflowManualTrigger subWorkflowManualTrigger;
    @Autowired
    private WorkflowInstanceRecoverFailureTaskTrigger workflowInstanceRecoverFailureTaskTrigger;
    @Autowired
    private WorkflowInstanceRecoverSuspendTaskTrigger workflowInstanceRecoverSuspendTaskTrigger;

    public Integer triggerSubWorkflow(WorkflowManualTriggerRequest workflowManualTriggerRequest) {
        return ((WorkflowManualTriggerResponse)this.subWorkflowManualTrigger.triggerWorkflow(workflowManualTriggerRequest)).getWorkflowInstanceId();
    }

    public WorkflowInstanceRecoverFailureTasksResponse triggerFromFailureTasks(WorkflowInstanceRecoverFailureTasksRequest recoverFailureTasksRequest) {
        return (WorkflowInstanceRecoverFailureTasksResponse)this.workflowInstanceRecoverFailureTaskTrigger.triggerWorkflow(recoverFailureTasksRequest);
    }

    public WorkflowInstanceRecoverSuspendTasksResponse triggerFromSuspendTasks(WorkflowInstanceRecoverSuspendTasksRequest recoverSuspendTasksRequest) {
        return (WorkflowInstanceRecoverSuspendTasksResponse)this.workflowInstanceRecoverSuspendTaskTrigger.triggerWorkflow(recoverSuspendTasksRequest);
    }

    public WorkflowInstancePauseResponse pauseWorkflowInstance(WorkflowInstancePauseRequest workflowInstancePauseRequest) throws MasterTaskExecuteException {
        Integer subWorkflowInstanceId = workflowInstancePauseRequest.getWorkflowInstanceId();
        WorkflowInstance subWorkflowInstance = (WorkflowInstance)this.workflowInstanceDao.queryById((Serializable)subWorkflowInstanceId);
        if (subWorkflowInstance.getState() != WorkflowExecutionStatus.RUNNING_EXECUTION) {
            return WorkflowInstancePauseResponse.fail((String)"SubWorkflow instance is not running, cannot pause");
        }
        try {
            return ((IWorkflowControlClient)Clients.withService(IWorkflowControlClient.class).withHost(subWorkflowInstance.getHost())).pauseWorkflowInstance(new WorkflowInstancePauseRequest(subWorkflowInstanceId));
        }
        catch (Exception e) {
            throw new MasterTaskExecuteException("Pause SubWorkflow: " + subWorkflowInstance.getName() + " failed", e);
        }
    }

    public WorkflowInstanceStopResponse stopWorkflowInstance(WorkflowInstanceStopRequest workflowInstanceStopRequest) throws MasterTaskExecuteException {
        Integer subWorkflowInstanceId = workflowInstanceStopRequest.getWorkflowInstanceId();
        WorkflowInstance subWorkflowInstance = (WorkflowInstance)this.workflowInstanceDao.queryById((Serializable)subWorkflowInstanceId);
        if (subWorkflowInstance.getState() != WorkflowExecutionStatus.RUNNING_EXECUTION) {
            return WorkflowInstanceStopResponse.fail((String)"SubWorkflow instance is not running, cannot stop");
        }
        try {
            return ((IWorkflowControlClient)Clients.withService(IWorkflowControlClient.class).withHost(subWorkflowInstance.getHost())).stopWorkflowInstance(new WorkflowInstanceStopRequest(subWorkflowInstance.getId()));
        }
        catch (Exception e) {
            throw new MasterTaskExecuteException("Kill SubWorkflow: " + subWorkflowInstance.getName() + " failed", e);
        }
    }
}

